/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.internal.services;

import java.util.Map;
import org.apache.tapestry5.commons.internal.services.StringInterner;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.PostInjection;

public class StringInternerImpl
implements StringInterner {
    private final Map<String, String> cache = CollectionFactory.newConcurrentMap();

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub hub) {
        hub.clearOnInvalidation(this.cache);
    }

    @Override
    public String intern(String string) {
        String result = this.cache.get(string);
        if (result == null) {
            this.cache.put(string, string);
            result = string;
        }
        return result;
    }

    @Override
    public String format(String format, Object ... arguments) {
        return this.intern(String.format(format, arguments));
    }
}

