/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.protobuf.SysdsProtos;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.UtilFunctions;

public class FrameReaderProto
extends FrameReader {
    @Override
    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        JobConf jobConf = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fileSystem = IOUtilFunctions.getFileSystem(path, (Configuration)jobConf);
        FileInputFormat.addInputPath((JobConf)jobConf, (Path)path);
        FrameReaderProto.checkValidInputFile(fileSystem, path);
        Types.ValueType[] outputSchema = FrameReaderProto.createOutputSchema(schema, clen);
        String[] outputNames = FrameReaderProto.createOutputNames(names, clen);
        FrameBlock outputFrameBlock = FrameReaderProto.createOutputFrameBlock(outputSchema, outputNames, rlen);
        FrameReaderProto.readProtoFrameFromHDFS(path, fileSystem, outputFrameBlock, rlen, clen);
        return outputFrameBlock;
    }

    private static void readProtoFrameFromHDFS(Path path, FileSystem fileSystem, FrameBlock dest, long rlen, long clen) throws IOException {
        SysdsProtos.Frame frame = FrameReaderProto.readProtoFrameFromFile(path, fileSystem);
        int row = 0;
        while ((long)row < rlen) {
            int column = 0;
            while ((long)column < clen) {
                dest.set(row, column, UtilFunctions.stringToObject(Types.ValueType.STRING, frame.getRows(row).getColumnData(column)));
                ++column;
            }
            ++row;
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fileSystem, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SysdsProtos.Frame readProtoFrameFromFile(Path path, FileSystem fileSystem) throws IOException {
        FSDataInputStream fsDataInputStream = fileSystem.open(path);
        try {
            SysdsProtos.Frame frame = ((SysdsProtos.Frame.Builder)SysdsProtos.Frame.newBuilder().mergeFrom((InputStream)fsDataInputStream)).build();
            return frame;
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)fsDataInputStream);
        }
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) {
        throw new DMLRuntimeException("Not implemented yet.");
    }
}

