/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.AColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.IContainDefaultTuple;
import org.apache.sysds.runtime.compress.colgroup.IFrameOfReferenceGroup;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCFOR
extends ASDC
implements IMapToDataGroup,
IFrameOfReferenceGroup {
    private static final long serialVersionUID = 3883228464052204203L;
    protected final AMapToData _data;
    protected final double[] _reference;

    private ColGroupSDCFOR(IColIndex colIndices, int numRows, IDictionary dict, AOffset indexes, AMapToData data, int[] cachedCounts, double[] reference) {
        super(colIndices, numRows, dict, indexes, cachedCounts);
        this._data = data;
        this._reference = reference;
        if (CompressedMatrixBlock.debug) {
            if (data.getUnique() == 1) {
                LOG.warn((Object)"SDCFor unique is 1, indicate it should have been SDCSingle please add support");
            } else if (data.getUnique() != dict.getNumberOfValues(colIndices.size())) {
                throw new DMLCompressionException("Invalid construction of SDCZero group");
            }
            this._data.verify();
            this._indexes.verify(this._data.size());
        }
    }

    public static AColGroup create(IColIndex colIndexes, int numRows, IDictionary dict, AOffset offsets, AMapToData data, int[] cachedCounts, double[] reference) {
        boolean allZero = ColGroupUtils.allZero(reference);
        if (allZero && dict == null) {
            return new ColGroupEmpty(colIndexes);
        }
        if (dict == null) {
            return ColGroupConst.create(colIndexes, reference);
        }
        if (allZero) {
            return ColGroupSDCZeros.create(colIndexes, numRows, dict, offsets, data, cachedCounts);
        }
        return new ColGroupSDCFOR(colIndexes, numRows, dict, offsets, data, cachedCounts, reference);
    }

    public static AColGroup sparsifyFOR(ColGroupSDC g) {
        double[] constV = g._defaultTuple;
        AColGroupValue clg = (AColGroupValue)g.subtractDefaultTuple();
        return ColGroupSDCFOR.create(g.getColIndices(), g._numRows, clg._dict, g._indexes, g._data, g.getCachedCounts(), constV);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDCFOR;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCFOR;
    }

    @Override
    public double[] getDefaultTuple() {
        return this._reference;
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    public AMapToData getMapToData() {
        return this._data;
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowSums(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowMxx(c, builtin, rl, ru, preAgg, this._data, this._indexes, this._numRows, preAgg[preAgg.length - 1]);
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return this._reference[colIdx];
        }
        return this._dict.getValue(this._data.getIndex(it.getDataIndex()), colIdx, this._colIndexes.size()) + this._reference[colIdx];
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double[] newRef = new double[this._reference.length];
        for (int i = 0; i < this._reference.length; ++i) {
            newRef[i] = op.executeScalar(this._reference[i]);
        }
        if (op.fn instanceof Plus || op.fn instanceof Minus) {
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            IDictionary newDict = this._dict.applyScalarOp(op);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        IDictionary newDict = this._dict.applyScalarOpWithReference(op, this._reference, newRef);
        return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double[] newRef = ColGroupUtils.unaryOperator(op, this._reference);
        IDictionary newDict = this._dict.applyUnaryOpWithReference(op, this._reference, newRef);
        return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newRef = new double[this._reference.length];
        for (int i = 0; i < this._reference.length; ++i) {
            newRef[i] = op.fn.execute(v[this._colIndexes.get(i)], this._reference[i]);
        }
        if (op.fn instanceof Plus || op.fn instanceof Minus) {
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            IDictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        IDictionary newDict = this._dict.binOpLeftWithReference(op, v, this._colIndexes, this._reference, newRef);
        return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newRef = new double[this._reference.length];
        for (int i = 0; i < this._reference.length; ++i) {
            newRef[i] = op.fn.execute(this._reference[i], v[this._colIndexes.get(i)]);
        }
        if (op.fn instanceof Plus || op.fn instanceof Minus) {
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            IDictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
        }
        IDictionary newDict = this._dict.binOpRightWithReference(op, v, this._colIndexes, this._reference, newRef);
        return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), newRef);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
        for (double d : this._reference) {
            out.writeDouble(d);
        }
    }

    public static ColGroupSDCFOR read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        AOffset indexes = OffsetFactory.readIn(in);
        AMapToData data = MapToFactory.readIn(in);
        double[] reference = ColGroupIO.readDoubleArray(cols.size(), in);
        return new ColGroupSDCFOR(cols, nRows, dict, indexes, data, null, reference);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._data.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += (long)(8 * this._colIndexes.size());
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        size += this._data.getInMemorySize();
        return size += (long)(8 * this._colIndexes.size());
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        IDictionary newDict = this._dict.replaceWithReference(pattern, replace, this._reference);
        boolean patternInReference = false;
        for (double d : this._reference) {
            if (pattern != d) continue;
            patternInReference = true;
            break;
        }
        if (patternInReference) {
            double[] nRef = new double[this._reference.length];
            for (int i = 0; i < this._reference.length; ++i) {
                nRef[i] = Util.eq(pattern, this._reference[i]) ? replace : this._reference[i];
            }
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), nRef);
        }
        return ColGroupSDCFOR.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts(), this._reference);
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        return this._dict.aggregateWithReference(c, builtin, this._reference, true);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateColsWithReference(c, builtin, this._colIndexes, this._reference, true);
    }

    @Override
    protected void computeSum(double[] c, int nRows) {
        super.computeSum(c, nRows);
        double refSum = ColGroupUtils.refSum(this._reference);
        c[0] = c[0] + refSum * (double)nRows;
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        super.computeColSums(c, nRows);
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            int n = this._colIndexes.get(i);
            c[n] = c[n] + this._reference[i] * (double)nRows;
        }
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
        c[0] = c[0] + this._dict.sumSqWithReference(this.getCounts(), this._reference);
        double refSum = ColGroupUtils.refSumSq(this._reference);
        c[0] = c[0] + refSum * (double)(this._numRows - this._data.size());
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
        this._dict.colSumSqWithReference(c, this.getCounts(), this._colIndexes, this._reference);
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            int n = this._colIndexes.get(i);
            c[n] = c[n] + this._reference[i] * this._reference[i] * (double)(this._numRows - this._data.size());
        }
    }

    @Override
    protected double[] preAggSumRows() {
        return this._dict.sumAllRowsToDoubleWithReference(this._reference);
    }

    @Override
    protected double[] preAggSumSqRows() {
        return this._dict.sumAllRowsToDoubleSqWithReference(this._reference);
    }

    @Override
    protected double[] preAggProductRows() {
        return this._dict.productAllRowsToDoubleWithReference(this._reference);
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return this._dict.aggregateRowsWithReference(builtin, this._reference);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        int count = this._numRows - this._data.size();
        this._dict.productWithReference(c, this.getCounts(), this._reference, count);
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowProduct(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        this._dict.colProductWithReference(c, this.getCounts(), this._colIndexes, this._reference);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            double v = c[this._colIndexes.get(x)];
            c[this._colIndexes.get((int)x)] = v != 0.0 ? v * Math.pow(this._reference[x], count) : 0.0;
        }
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, IColIndex outputCols) {
        IDictionary retDict = this._dict.sliceOutColumnRange(idStart, idEnd, this._colIndexes.size());
        double[] newDef = new double[idEnd - idStart];
        int i = idStart;
        int j = 0;
        while (i < idEnd) {
            newDef[j] = this._reference[i];
            ++i;
            ++j;
        }
        return ColGroupSDCFOR.create(outputCols, this._numRows, retDict, this._indexes, this._data, this.getCounts(), newDef);
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        IColIndex retIndexes = ColIndexFactory.create(1);
        if (this._colIndexes.size() == 1) {
            return ColGroupSDCFOR.create(retIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCounts(), this._reference);
        }
        double[] newDef = new double[]{this._reference[idx]};
        IDictionary retDict = this._dict.sliceOutColumnRange(idx, idx + 1, this._colIndexes.size());
        return ColGroupSDCFOR.create(retIndexes, this._numRows, retDict, this._indexes, this._data, this.getCounts(), newDef);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (Double.isNaN(pattern) || Double.isInfinite(pattern)) {
            return ColGroupUtils.containsInfOrNan(pattern, this._reference) || this._dict.containsValue(pattern);
        }
        for (double v : this._reference) {
            if (v != pattern) continue;
            return true;
        }
        return this._dict.containsValueWithReference(pattern, this._reference);
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        int[] counts = this.getCounts();
        int count = this._numRows - this._data.size();
        long c = this._dict.getNumberNonZerosWithReference(counts, this._reference, nRows);
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c += this._reference[x] != 0.0 ? (long)count : 0L;
        }
        return c;
    }

    @Override
    public AColGroup extractCommon(double[] constV) {
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            int n = this._colIndexes.get(i);
            constV[n] = constV[n] + this._reference[i];
        }
        return ColGroupSDCZeros.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCounts());
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        IDictionary d = this._dict.rexpandColsWithReference(max, ignore, cast, (int)this._reference[0]);
        return ColGroupSDC.rexpandCols(max, ignore, cast, nRows, d, this._indexes, this._data, this.getCachedCounts(), (int)this._reference[0], this._dict.getNumberOfValues(1));
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._dict.centralMomentWithReference(op.fn, this.getCounts(), this._reference[0], nRows);
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this._data.size();
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    public double[] getCommon() {
        return this._reference;
    }

    @Override
    protected AColGroup allocateRightMultiplicationCommon(double[] common, IColIndex colIndexes, IDictionary preAgg) {
        return ColGroupSDCFOR.create(colIndexes, this._numRows, preAgg, this._indexes, this._data, this.getCachedCounts(), common);
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        AOffset.OffsetSliceInfo off = this._indexes.slice(rl, ru);
        if (off.lIndex == -1) {
            return ColGroupConst.create(this._colIndexes, (IDictionary)Dictionary.create(this._reference));
        }
        AMapToData newData = this._data.slice(off.lIndex, off.uIndex);
        return ColGroupSDCFOR.create(this._colIndexes, ru - rl, this._dict, off.offsetSlice, newData, null, this._reference);
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupSDCFOR.create(colIndexes, this._numRows, newDictionary, this._indexes, this._data, this.getCachedCounts(), this._reference);
    }

    @Override
    public AColGroup append(AColGroup g) {
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        for (int i = 1; i < g.length; ++i) {
            if (!this._colIndexes.equals(g[i]._colIndexes)) {
                LOG.warn((Object)("Not same columns therefore not appending \n" + this._colIndexes + "\n\n" + g[i]._colIndexes));
                return null;
            }
            if (!(g[i] instanceof ColGroupSDCFOR)) {
                LOG.warn((Object)("Not SDCFOR but " + g[i].getClass().getSimpleName()));
                return null;
            }
            ColGroupSDCFOR gc = (ColGroupSDCFOR)g[i];
            if (gc._dict.equals(this._dict)) continue;
            LOG.warn((Object)("Not same Dictionaries therefore not appending \n" + this._dict + "\n\n" + gc._dict));
            return null;
        }
        AMapToData nd = this._data.appendN((IMapToDataGroup[])Arrays.copyOf(g, g.length, IMapToDataGroup[].class));
        AOffset no = this._indexes.appendN((AOffsetsGroup[])Arrays.copyOf(g, g.length, AOffsetsGroup[].class), this.getNumRows());
        return ColGroupSDCFOR.create(this._colIndexes, rlen, this._dict, no, nd, null, this._reference);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public IEncode getEncoding() {
        return EncodingFactory.create(this._data, this._indexes, this._numRows);
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that instanceof ColGroupSDCFOR) {
            ColGroupSDCFOR th = (ColGroupSDCFOR)that;
            return th._indexes == this._indexes && th._data == this._data;
        }
        return false;
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        throw new NotImplementedException();
    }

    @Override
    public int getNumberOffsets() {
        return this._data.size();
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        throw new NotImplementedException();
    }

    @Override
    public void sparseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected void denseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, List<AColGroup> right) {
        IDictionary combined = this.combineDictionaries(nCol, right);
        IColIndex combinedColIndex = this.combineColIndexes(nCol, right);
        double[] combinedDefaultTuple = IContainDefaultTuple.combineDefaultTuples(this._reference, right);
        return new ColGroupSDCFOR(combinedColIndex, this.getNumRows(), combined, this._indexes, this._data, this.getCachedCounts(), combinedDefaultTuple);
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, AColGroup right) {
        ColGroupSDCFOR rightSDC = (ColGroupSDCFOR)right;
        IDictionary b = rightSDC.getDictionary();
        IDictionary combined = DictionaryFactory.cBindDictionaries(this._dict, b, this.getNumCols(), right.getNumCols());
        IColIndex combinedColIndex = this._colIndexes.combine(right.getColIndices().shift(nCol));
        double[] combinedDefaultTuple = new double[this._reference.length + rightSDC._reference.length];
        System.arraycopy(this._reference, 0, combinedDefaultTuple, 0, this._reference.length);
        System.arraycopy(rightSDC._reference, 0, combinedDefaultTuple, this._reference.length, rightSDC._reference.length);
        return new ColGroupSDCFOR(combinedColIndex, this.getNumRows(), combined, this._indexes, this._data, this.getCachedCounts(), combinedDefaultTuple);
    }

    @Override
    public AColGroup[] splitReshape(int multiplier, int nRow, int nColOrg) {
        int outM;
        int outV;
        int m;
        int d;
        int v;
        IntArrayList[] splitOffs = new IntArrayList[multiplier];
        IntArrayList[] tmpMaps = new IntArrayList[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            splitOffs[i] = new IntArrayList();
            tmpMaps[i] = new IntArrayList();
        }
        AIterator it = this._indexes.getIterator();
        int last = this._indexes.getOffsetToLast();
        while (it.value() != last) {
            v = it.value();
            d = it.getDataIndex();
            m = this._data.getIndex(d);
            outV = v / multiplier;
            outM = v % multiplier;
            tmpMaps[outM].appendValue(m);
            splitOffs[outM].appendValue(outV);
            it.next();
        }
        v = it.value();
        d = it.getDataIndex();
        m = this._data.getIndex(d);
        outV = v / multiplier;
        outM = v % multiplier;
        tmpMaps[outM].appendValue(m);
        splitOffs[outM].appendValue(outV);
        AOffset[] offs = new AOffset[multiplier];
        AMapToData[] maps = new AMapToData[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            offs[i] = OffsetFactory.createOffset(splitOffs[i]);
            maps[i] = MapToFactory.create(this._data.getUnique(), tmpMaps[i]);
        }
        AColGroup[] res = new AColGroup[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            IColIndex ci = i == 0 ? this._colIndexes : this._colIndexes.shift(i * nColOrg);
            res[i] = ColGroupSDCFOR.create(ci, this._numRows / multiplier, this._dict, offs[i], maps[i], null, this._reference);
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data);
        sb.append(String.format("\n%15s", "Reference:"));
        sb.append(Arrays.toString(this._reference));
        return sb.toString();
    }
}

