/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMultifactorAuthenticationTriggerSelectionStrategy
implements MultifactorAuthenticationTriggerSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationTriggerSelectionStrategy.class);
    private final Collection<MultifactorAuthenticationTrigger> multifactorAuthenticationTriggers;

    public Optional<MultifactorAuthenticationProvider> resolve(HttpServletRequest request, HttpServletResponse response, RegisteredService registeredService, Authentication authentication, Service service) throws Throwable {
        if (registeredService != null && registeredService.getMultifactorAuthenticationPolicy().isBypassEnabled()) {
            LOGGER.debug("Multifactor authentication policy for [{}] will ignore trigger executions", (Object)registeredService.getName());
            return Optional.empty();
        }
        for (MultifactorAuthenticationTrigger trigger : this.multifactorAuthenticationTriggers) {
            Optional activated;
            if (BeanSupplier.isNotProxy((Object)trigger) && !trigger.supports(request, registeredService, authentication, service) || !(activated = trigger.isActivated(authentication, registeredService, request, response, service)).isPresent()) continue;
            return activated;
        }
        return Optional.empty();
    }

    @Generated
    public DefaultMultifactorAuthenticationTriggerSelectionStrategy(Collection<MultifactorAuthenticationTrigger> multifactorAuthenticationTriggers) {
        this.multifactorAuthenticationTriggers = multifactorAuthenticationTriggers;
    }

    @Generated
    public Collection<MultifactorAuthenticationTrigger> getMultifactorAuthenticationTriggers() {
        return this.multifactorAuthenticationTriggers;
    }
}

