/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;

public class DeleteExternalWorkerJobCmd
implements Command<Object> {
    protected String jobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public DeleteExternalWorkerJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        ExternalWorkerJobEntityManager jobEntityManager = this.jobServiceConfiguration.getExternalWorkerJobEntityManager();
        ExternalWorkerJobEntity job = (ExternalWorkerJobEntity)jobEntityManager.findById(this.jobId);
        if (job == null) {
            throw new FlowableObjectNotFoundException("No external worker job found with id '" + this.jobId + "'", Job.class);
        }
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job), this.jobServiceConfiguration.getEngineName());
        }
        jobEntityManager.delete(job);
        return null;
    }
}

