/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.DefaultPolicyBuilder;
import com.okta.sdk.resource.policy.GroupCondition;
import com.okta.sdk.resource.policy.PasswordDictionary;
import com.okta.sdk.resource.policy.PasswordDictionaryCommon;
import com.okta.sdk.resource.policy.PasswordPolicy;
import com.okta.sdk.resource.policy.PasswordPolicyAuthenticationProviderCondition;
import com.okta.sdk.resource.policy.PasswordPolicyBuilder;
import com.okta.sdk.resource.policy.PasswordPolicyConditions;
import com.okta.sdk.resource.policy.PasswordPolicyDelegationSettings;
import com.okta.sdk.resource.policy.PasswordPolicyDelegationSettingsOptions;
import com.okta.sdk.resource.policy.PasswordPolicyPasswordSettings;
import com.okta.sdk.resource.policy.PasswordPolicyPasswordSettingsAge;
import com.okta.sdk.resource.policy.PasswordPolicyPasswordSettingsComplexity;
import com.okta.sdk.resource.policy.PasswordPolicyPasswordSettingsLockout;
import com.okta.sdk.resource.policy.PasswordPolicyRecoveryEmail;
import com.okta.sdk.resource.policy.PasswordPolicyRecoveryEmailProperties;
import com.okta.sdk.resource.policy.PasswordPolicyRecoveryEmailRecoveryToken;
import com.okta.sdk.resource.policy.PasswordPolicyRecoveryFactorSettings;
import com.okta.sdk.resource.policy.PasswordPolicyRecoveryFactors;
import com.okta.sdk.resource.policy.PasswordPolicyRecoverySettings;
import com.okta.sdk.resource.policy.PasswordPolicySettings;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyPeopleCondition;
import com.okta.sdk.resource.policy.PolicyType;
import com.okta.sdk.resource.policy.UserCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultPasswordPolicyBuilder
extends DefaultPolicyBuilder<PasswordPolicyBuilder>
implements PasswordPolicyBuilder {
    private PasswordPolicyAuthenticationProviderCondition.ProviderEnum provider;
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();
    private Boolean excludePasswordDictionary;
    private Boolean excludeUserNameInPassword;
    private Integer minPasswordLength;
    private Integer minLowercase;
    private Integer minUpperCase;
    private Integer minNumbers;
    private Integer minSymbols;
    private Boolean skipUnlock;
    private Integer pwdExpireWarnDays;
    private Integer pwdHistoryCount;
    private Integer pwdMaxAgeDays;
    private Integer pwdMinMinutes;
    private Integer pwdAutoUnlockMinutes;
    private Integer pwdMaxAttempts;
    private Boolean showLockoutFailures;
    private PasswordPolicyRecoveryFactorSettings.StatusEnum pwdRecoveryOktaCall;
    private PasswordPolicyRecoveryFactorSettings.StatusEnum pwdRecoveryOktaSMS;
    private PasswordPolicyRecoveryFactorSettings.StatusEnum pwdPolicyRecoveryEmailStatus;
    private Integer pwdRecoveryTokenLifeMinutes;

    public DefaultPasswordPolicyBuilder() {
        this.policyType = PolicyType.PASSWORD;
    }

    public PasswordPolicyBuilder setAuthProvider(PasswordPolicyAuthenticationProviderCondition.ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    public PasswordPolicyBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public PasswordPolicyBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public PasswordPolicyBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public PasswordPolicyBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public PasswordPolicyBuilder setExcludePasswordDictionary(Boolean enablePasswordDictionary) {
        this.excludePasswordDictionary = enablePasswordDictionary;
        return this;
    }

    public PasswordPolicyBuilder setExcludeUserNameInPassword(Boolean excludeUserNameInPassword) {
        this.excludeUserNameInPassword = excludeUserNameInPassword;
        return this;
    }

    public PasswordPolicyBuilder setMinPasswordLength(Integer minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
        return this;
    }

    public PasswordPolicyBuilder setMinLowerCase(Integer minLowerCase) {
        this.minLowercase = minLowerCase;
        return this;
    }

    public PasswordPolicyBuilder setMinUpperCase(Integer minUpperCase) {
        this.minUpperCase = minUpperCase;
        return this;
    }

    public PasswordPolicyBuilder setMinNumbers(Integer minNumbers) {
        this.minNumbers = minNumbers;
        return this;
    }

    public PasswordPolicyBuilder setMinSymbols(Integer minSymbols) {
        this.minSymbols = minSymbols;
        return this;
    }

    public PasswordPolicyBuilder setSkipUnlock(Boolean skipUnlock) {
        this.skipUnlock = skipUnlock;
        return this;
    }

    public PasswordPolicyBuilder setPasswordExpireWarnDays(Integer pwdExpireWarnDays) {
        this.pwdExpireWarnDays = pwdExpireWarnDays;
        return this;
    }

    public PasswordPolicyBuilder setPasswordHistoryCount(Integer pwdHistoryCount) {
        this.pwdHistoryCount = pwdHistoryCount;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMaxAgeDays(Integer pwdMaxAgeDays) {
        this.pwdMaxAgeDays = pwdMaxAgeDays;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMinMinutes(Integer pwdMinMinutes) {
        this.pwdMinMinutes = pwdMinMinutes;
        return this;
    }

    public PasswordPolicyBuilder setPasswordAutoUnlockMinutes(Integer pwdAutoUnlockMinutes) {
        this.pwdAutoUnlockMinutes = pwdAutoUnlockMinutes;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMaxAttempts(Integer pwdMaxAttempts) {
        this.pwdMaxAttempts = pwdMaxAttempts;
        return this;
    }

    public PasswordPolicyBuilder setShowLockoutFailures(Boolean showLockoutFailures) {
        this.showLockoutFailures = showLockoutFailures;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryOktaCall(PasswordPolicyRecoveryFactorSettings.StatusEnum pwdRecoveryOktaCall) {
        this.pwdRecoveryOktaCall = pwdRecoveryOktaCall;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryOktaSMS(PasswordPolicyRecoveryFactorSettings.StatusEnum pwdRecoveryOktaSMS) {
        this.pwdRecoveryOktaSMS = pwdRecoveryOktaSMS;
        return this;
    }

    public PasswordPolicyBuilder setPasswordPolicyRecoveryEmailStatus(PasswordPolicyRecoveryFactorSettings.StatusEnum status) {
        this.pwdPolicyRecoveryEmailStatus = status;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryTokenLifeMinutes(Integer pwdRecoveryTokenLifeMinutes) {
        this.pwdRecoveryTokenLifeMinutes = pwdRecoveryTokenLifeMinutes;
        return this;
    }

    public PasswordPolicy buildAndCreate(Client client) {
        return (PasswordPolicy)client.createPolicy((Policy)this.build(client), this.isActive);
    }

    private PasswordPolicy build(Client client) {
        PasswordPolicy policy = (PasswordPolicy)client.instantiate(PasswordPolicy.class);
        policy.setConditions((PasswordPolicyConditions)client.instantiate(PasswordPolicyConditions.class));
        PasswordPolicyConditions passwordPolicyConditions = policy.getConditions();
        policy.setSettings((PasswordPolicySettings)client.instantiate(PasswordPolicySettings.class));
        PasswordPolicySettings passwordPolicySettings = policy.getSettings();
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!this.policyType.equals((Object)PolicyType.PASSWORD)) {
            throw new IllegalArgumentException("PolicyType should be 'PASSWORD', please use PolicyBuilder for other policy types.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        if (Objects.nonNull(this.provider)) {
            passwordPolicyConditions.setAuthProvider(((PasswordPolicyAuthenticationProviderCondition)client.instantiate(PasswordPolicyAuthenticationProviderCondition.class)).setProvider(this.provider));
        }
        if (!Collections.isEmpty(this.groupIds)) {
            passwordPolicyConditions.setPeople(((PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class)).setGroups(((GroupCondition)client.instantiate(GroupCondition.class)).setInclude(this.groupIds)));
        }
        if (!Collections.isEmpty(this.userIds)) {
            passwordPolicyConditions.setPeople(((PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class)).setUsers(((UserCondition)client.instantiate(UserCondition.class)).setInclude(this.userIds)));
        }
        PasswordPolicyPasswordSettings passwordPolicyPasswordSettings = (PasswordPolicyPasswordSettings)client.instantiate(PasswordPolicyPasswordSettings.class);
        PasswordPolicyPasswordSettingsComplexity passwordPolicyPasswordSettingsComplexity = (PasswordPolicyPasswordSettingsComplexity)client.instantiate(PasswordPolicyPasswordSettingsComplexity.class);
        if (Objects.nonNull(this.excludePasswordDictionary)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setDictionary(((PasswordDictionary)client.instantiate(PasswordDictionary.class)).setCommon(((PasswordDictionaryCommon)client.instantiate(PasswordDictionaryCommon.class)).setExclude(this.excludePasswordDictionary)))));
        }
        if (Objects.nonNull(this.excludeUserNameInPassword)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setExcludeUsername(this.excludeUserNameInPassword)));
        }
        if (Objects.nonNull(this.minPasswordLength)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setMinLength(this.minPasswordLength)));
        }
        if (Objects.nonNull(this.minLowercase)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setMinLowerCase(this.minLowercase)));
        }
        if (Objects.nonNull(this.minUpperCase)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setMinUpperCase(this.minUpperCase)));
        }
        if (Objects.nonNull(this.minNumbers)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setMinNumber(this.minNumbers)));
        }
        if (Objects.nonNull(this.minSymbols)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity.setMinSymbol(this.minSymbols)));
        }
        if (Objects.nonNull(this.skipUnlock)) {
            passwordPolicySettings.setDelegation(((PasswordPolicyDelegationSettings)client.instantiate(PasswordPolicyDelegationSettings.class)).setOptions(((PasswordPolicyDelegationSettingsOptions)client.instantiate(PasswordPolicyDelegationSettingsOptions.class)).setSkipUnlock(this.skipUnlock)));
        }
        PasswordPolicyPasswordSettingsAge passwordPolicyPasswordSettingsAge = (PasswordPolicyPasswordSettingsAge)client.instantiate(PasswordPolicyPasswordSettingsAge.class);
        if (Objects.nonNull(this.pwdExpireWarnDays)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge.setExpireWarnDays(this.pwdExpireWarnDays)));
        }
        if (Objects.nonNull(this.pwdHistoryCount)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge.setHistoryCount(this.pwdHistoryCount)));
        }
        if (Objects.nonNull(this.pwdMaxAgeDays)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge.setMaxAgeDays(this.pwdMaxAgeDays)));
        }
        if (Objects.nonNull(this.pwdMinMinutes)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge.setMinAgeMinutes(this.pwdMinMinutes)));
        }
        PasswordPolicyPasswordSettingsLockout passwordPolicyPasswordSettingsLockout = (PasswordPolicyPasswordSettingsLockout)client.instantiate(PasswordPolicyPasswordSettingsLockout.class);
        if (Objects.nonNull(this.pwdAutoUnlockMinutes)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout.setAutoUnlockMinutes(this.pwdAutoUnlockMinutes)));
        }
        if (Objects.nonNull(this.pwdMaxAttempts)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout.setMaxAttempts(this.pwdMaxAttempts)));
        }
        if (Objects.nonNull(this.showLockoutFailures)) {
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout.setShowLockoutFailures(this.showLockoutFailures)));
        }
        PasswordPolicyRecoverySettings passwordPolicyRecoverySettings = (PasswordPolicyRecoverySettings)client.instantiate(PasswordPolicyRecoverySettings.class);
        PasswordPolicyRecoveryFactors passwordPolicyRecoveryFactors = (PasswordPolicyRecoveryFactors)client.instantiate(PasswordPolicyRecoveryFactors.class);
        if (Objects.nonNull(this.pwdRecoveryOktaCall)) {
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors.setOktaCall(((PasswordPolicyRecoveryFactorSettings)client.instantiate(PasswordPolicyRecoveryFactorSettings.class)).setStatus(this.pwdRecoveryOktaCall))));
        }
        if (Objects.nonNull(this.pwdRecoveryOktaSMS)) {
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors.setOktaSms(((PasswordPolicyRecoveryFactorSettings)client.instantiate(PasswordPolicyRecoveryFactorSettings.class)).setStatus(this.pwdRecoveryOktaSMS))));
        }
        PasswordPolicyRecoveryEmail passwordPolicyRecoveryEmail = (PasswordPolicyRecoveryEmail)client.instantiate(PasswordPolicyRecoveryEmail.class);
        if (Objects.nonNull(this.pwdPolicyRecoveryEmailStatus)) {
            ((AbstractResource)passwordPolicyRecoveryEmail).setProperty("status", this.pwdPolicyRecoveryEmailStatus, true);
        }
        if (Objects.nonNull(this.pwdRecoveryTokenLifeMinutes)) {
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors.setOktaEmail(passwordPolicyRecoveryEmail.setProperties(((PasswordPolicyRecoveryEmailProperties)client.instantiate(PasswordPolicyRecoveryEmailProperties.class)).setRecoveryToken(((PasswordPolicyRecoveryEmailRecoveryToken)client.instantiate(PasswordPolicyRecoveryEmailRecoveryToken.class)).setTokenLifetimeMinutes(this.pwdRecoveryTokenLifeMinutes))))));
        }
        return policy;
    }
}

