/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.Optional;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.LiveSyncApiOp;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.LiveSyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.LiveSyncResultsHandler;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.impl.api.local.operations.AttributesToGetResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingLiveSyncResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.AttributeNormalizer;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.LiveSyncOp;

public class LiveSyncImpl
extends ConnectorAPIOperationRunner
implements LiveSyncApiOp {
    private static final Log OP_LOG = Log.getLog(LiveSyncOp.class);

    public LiveSyncImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public void livesync(ObjectClass objectClass, LiveSyncResultsHandler handler, OperationOptions options) {
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        Assertions.nullCheck((Object)handler, (String)"handler");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ResultsHandlerConfiguration hdlCfg = null != this.getOperationalContext() ? this.getOperationalContext().getResultsHandlerConfiguration() : new ResultsHandlerConfiguration();
        String[] attrsToGet = options.getAttributesToGet();
        if (attrsToGet != null && attrsToGet.length > 0 && hdlCfg.isEnableAttributesToGetSearchResultsHandler()) {
            handler = new AttributesToGetLiveSyncResultsHandler(handler, attrsToGet);
        }
        if (this.getConnector() instanceof AttributeNormalizer && hdlCfg.isEnableNormalizingResultsHandler()) {
            handler = new NormalizingLiveSyncResultsHandler(handler, this.getNormalizer(objectClass));
        }
        SpiOperationLoggingUtil.logOpEntry(OP_LOG, this.getOperationalContext(), LiveSyncOp.class, "livesync", objectClass, options);
        try {
            ((LiveSyncOp)this.getConnector()).livesync(objectClass, handler, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), LiveSyncOp.class, "livesync", e);
            throw e;
        }
        SpiOperationLoggingUtil.logOpExit(OP_LOG, this.getOperationalContext(), LiveSyncOp.class, "livesync");
    }

    public static class AttributesToGetLiveSyncResultsHandler
    extends AttributesToGetResultsHandler
    implements LiveSyncResultsHandler {
        private final LiveSyncResultsHandler handler;

        public AttributesToGetLiveSyncResultsHandler(LiveSyncResultsHandler handler, String[] attrsToGet) {
            super(attrsToGet);
            this.handler = handler;
        }

        public boolean handle(LiveSyncDelta delta) {
            LiveSyncDeltaBuilder bld = new LiveSyncDeltaBuilder(delta);
            Optional.ofNullable(delta.getObject()).ifPresent(obj -> bld.setObject(this.reduceToAttrsToGet((ConnectorObject)obj)));
            return this.handler.handle(bld.build());
        }
    }
}

