/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.ProtocolAwareAssetPathCollector;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;

@Deprecated
public class JarAssetPathCollector
extends ProtocolAwareAssetPathCollector {
    public JarAssetPathCollector() {
        super("jar");
    }

    protected JarAssetPathCollector(String ... protocols) {
        super(protocols);
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        JarFile jarFile = this.newJarFile(url);
        HashSet<String> assetPaths = new HashSet<String>();
        String jarFileName = jarFile.getName();
        boolean isArchive = jarFileName.endsWith(".war") || jarFileName.endsWith(".jar");
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String assetPathCandidate = entry.getName();
            if (isArchive && assetPathCandidate.endsWith(".jar")) {
                this.collectInnerJar(jarFile, entry, assetPaths, filterExpr);
                continue;
            }
            if (entry.isDirectory() || !filterExpr.matcher("/" + assetPathCandidate).matches()) continue;
            assetPaths.add(assetPathCandidate);
        }
        return assetPaths;
    }

    protected void collectInnerJar(JarFile jarFile, JarEntry entry, Set<String> assetPaths, Pattern filterExpr) {
        try {
            String innerJarEntryName;
            JarEntry innerJarEntry;
            InputStream inputStream = jarFile.getInputStream(entry);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            while ((innerJarEntry = jarInputStream.getNextJarEntry()) != null && filterExpr.matcher(innerJarEntryName = innerJarEntry.getName()).matches()) {
                if (innerJarEntry.isDirectory() || !filterExpr.matcher(innerJarEntryName).matches()) continue;
                assetPaths.add(innerJarEntryName);
            }
        }
        catch (IOException e) {
            throw new WebJarAssetLocator.ResourceException(jarFile.getName(), e.getMessage());
        }
    }

    protected JarFile newJarFile(URL url) {
        try {
            String path = url.getPath();
            File file = new File(URI.create(path.substring(0, path.indexOf("!"))));
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new WebJarAssetLocator.ResourceException(url.toString(), e.getMessage());
        }
    }
}

