/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.context;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.EmbeddedKafkaBrokerFactory;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class EmbeddedKafkaContextCustomizer
implements ContextCustomizer {
    private final EmbeddedKafka embeddedKafka;

    EmbeddedKafkaContextCustomizer(EmbeddedKafka embeddedKafka) {
        this.embeddedKafka = embeddedKafka;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        ConfigurableEnvironment environment = context.getEnvironment();
        EmbeddedKafkaBroker embeddedKafkaBroker = EmbeddedKafkaBrokerFactory.create(this.embeddedKafka, arg_0 -> ((ConfigurableEnvironment)environment).resolvePlaceholders(arg_0));
        ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition("embeddedKafka", (BeanDefinition)new RootBeanDefinition(EmbeddedKafkaBroker.class, () -> embeddedKafkaBroker));
    }

    public int hashCode() {
        return this.embeddedKafka.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EmbeddedKafkaContextCustomizer customizer = (EmbeddedKafkaContextCustomizer)obj;
        return this.embeddedKafka.equals(customizer.embeddedKafka);
    }
}

