/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;

public class BulkDeleteHistoricProcessInstancesCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Collection<String> processInstanceIds;

    public BulkDeleteHistoricProcessInstancesCmd(Collection<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public Object execute(CommandContext commandContext) {
        if (this.processInstanceIds == null) {
            throw new FlowableIllegalArgumentException("processInstanceIds is null");
        }
        if (this.processInstanceIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("processInstanceIds is empty");
        }
        CommandContextUtil.getHistoryManager(commandContext).recordBulkDeleteProcessInstances(this.processInstanceIds);
        return null;
    }
}

