/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.http.handler;

import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.http.delegate.HttpRequestHandlerInvocation;
import org.flowable.engine.impl.bpmn.http.delegate.HttpResponseHandlerInvocation;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.api.delegate.HttpRequestHandler;
import org.flowable.http.common.api.delegate.HttpResponseHandler;

public class DelegateExpressionHttpHandler
implements HttpRequestHandler,
HttpResponseHandler {
    protected Expression expression;
    protected final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionHttpHandler(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    public void handleHttpRequest(VariableContainer execution, HttpRequest httpRequest, FlowableHttpClient client) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (!(delegate instanceof HttpRequestHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(HttpRequestHandler.class));
        }
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new HttpRequestHandlerInvocation((HttpRequestHandler)delegate, execution, httpRequest, client));
    }

    public void handleHttpResponse(VariableContainer execution, HttpResponse httpResponse) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (!(delegate instanceof HttpResponseHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(HttpResponseHandler.class));
        }
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new HttpResponseHandlerInvocation((HttpResponseHandler)delegate, execution, httpResponse));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

