/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.SharedMapDecorator;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.test.MockParameterMap;

public class MockExternalContext
implements ExternalContext {
    private String contextPath;
    private ParameterMap requestParameterMap = new MockParameterMap();
    private MutableAttributeMap<Object> requestMap = new LocalAttributeMap<Object>();
    private SharedAttributeMap<Object> sessionMap = new LocalSharedAttributeMap<Object>((SharedMap<String, Object>)new SharedMapDecorator(new HashMap()));
    private SharedAttributeMap<Object> globalSessionMap = this.sessionMap;
    private SharedAttributeMap<Object> applicationMap = new LocalSharedAttributeMap<Object>((SharedMap<String, Object>)new SharedMapDecorator(new HashMap()));
    private Object nativeContext = new Object();
    private Object nativeRequest = new Object();
    private Object nativeResponse = new Object();
    private Principal currentUser;
    private Locale locale;
    private StringWriter responseWriter = new StringWriter();
    private boolean ajaxRequest;
    private Boolean responseAllowed;
    private boolean responseComplete;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap<Object> flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private boolean redirectInPopup;

    public MockExternalContext() {
    }

    public MockExternalContext(ParameterMap requestParameterMap) {
        if (requestParameterMap != null) {
            this.requestParameterMap = requestParameterMap;
        }
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public MutableAttributeMap<Object> getRequestMap() {
        return this.requestMap;
    }

    @Override
    public SharedAttributeMap<Object> getSessionMap() {
        return this.sessionMap;
    }

    @Override
    public SharedAttributeMap<Object> getGlobalSessionMap() {
        return this.globalSessionMap;
    }

    @Override
    public SharedAttributeMap<Object> getApplicationMap() {
        return this.applicationMap;
    }

    @Override
    public Principal getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Object getNativeContext() {
        return this.nativeContext;
    }

    @Override
    public Object getNativeRequest() {
        return this.nativeRequest;
    }

    @Override
    public Object getNativeResponse() {
        return this.nativeResponse;
    }

    @Override
    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    @Override
    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        return "/" + flowId + "?execution=" + flowExecutionKey;
    }

    @Override
    public Writer getResponseWriter() {
        this.assertResponseAllowed();
        return this.responseWriter;
    }

    @Override
    public boolean isResponseAllowed() {
        if (this.responseAllowed != null) {
            return this.responseAllowed;
        }
        return !this.responseComplete;
    }

    @Override
    public boolean isResponseComplete() {
        return this.responseComplete;
    }

    @Override
    public void recordResponseComplete() {
        this.responseComplete = true;
    }

    @Override
    public boolean isResponseCompleteFlowExecutionRedirect() {
        return this.flowExecutionRedirectRequested;
    }

    @Override
    public void requestFlowExecutionRedirect() throws IllegalStateException {
        this.flowExecutionRedirectRequested = true;
        this.recordResponseComplete();
    }

    @Override
    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap<?> input) throws IllegalStateException {
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = new LocalAttributeMap<Object>();
        if (input != null) {
            this.flowDefinitionRedirectFlowInput.putAll(input);
        }
        this.recordResponseComplete();
    }

    @Override
    public void requestExternalRedirect(String uri) throws IllegalStateException {
        this.externalRedirectUrl = uri;
        this.recordResponseComplete();
    }

    @Override
    public void requestRedirectInPopup() throws IllegalStateException {
        if (!this.isRedirectRequested()) {
            throw new IllegalStateException("Only call requestRedirectInPopup after a redirect has been requested by calling requestFlowExecutionRedirect, requestFlowDefinitionRedirect, or requestExternalRedirect");
        }
        this.redirectInPopup = true;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setRequestParameterMap(ParameterMap requestParameterMap) {
        this.requestParameterMap = requestParameterMap;
    }

    public void setRequestMap(MutableAttributeMap<Object> requestMap) {
        this.requestMap = requestMap;
    }

    public void setSessionMap(SharedAttributeMap<Object> sessionMap) {
        this.sessionMap = sessionMap;
    }

    public void setGlobalSessionMap(SharedAttributeMap<Object> globalSessionMap) {
        this.globalSessionMap = globalSessionMap;
    }

    public void setApplicationMap(SharedAttributeMap<Object> applicationMap) {
        this.applicationMap = applicationMap;
    }

    public void setNativeContext(Object nativeContext) {
        this.nativeContext = nativeContext;
    }

    public void setNativeRequest(Object nativeRequest) {
        this.nativeRequest = nativeRequest;
    }

    public void setNativeResponse(Object nativeResponse) {
        this.nativeResponse = nativeResponse;
    }

    public void setCurrentUser(Principal currentUser) {
        this.currentUser = currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = new MockPrincipal(currentUser);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public MockParameterMap getMockRequestParameterMap() {
        return (MockParameterMap)this.requestParameterMap;
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockRequestParameterMap().put(parameterName, parameterValues);
    }

    public void putRequestParameter(String parameterName, MultipartFile parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, List<MultipartFile> parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void setEventId(String eventId) {
        this.putRequestParameter("_eventId", eventId);
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public void setResponseAllowed(boolean responseAllowed) {
        this.responseAllowed = responseAllowed;
    }

    public StringWriter getMockResponseWriter() {
        return this.responseWriter;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap<Object> getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    private void assertResponseAllowed() throws IllegalStateException {
        if (!this.isResponseAllowed()) {
            if (this.getFlowExecutionRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because a redirect has already been requested on this ExternalContext");
            }
            if (this.getFlowDefinitionRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because a flowRedirect has already been requested on this ExternalContext");
            }
            if (this.getExternalRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because an externalRedirect has already been requested on this ExternalContext");
            }
            if (this.responseComplete) {
                throw new IllegalStateException("A response is not allowed because one has already been completed on this ExternalContext");
            }
            throw new IllegalStateException("A response is not allowed");
        }
    }

    public boolean isRedirectRequested() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }

    private class MockPrincipal
    implements Principal {
        private String name;

        private MockPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

