/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.web;

import java.util.Map;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.springframework.webflow.core.collection.AttributeMapBindingEvent;
import org.springframework.webflow.core.collection.AttributeMapBindingListener;
import org.springframework.webflow.core.collection.LocalAttributeMap;

public class HttpSessionMapBindingListener
implements HttpSessionBindingListener {
    private AttributeMapBindingListener listener;
    private Map<String, Object> sessionMap;

    public HttpSessionMapBindingListener(AttributeMapBindingListener listener, Map<String, Object> sessionMap) {
        this.listener = listener;
        this.sessionMap = sessionMap;
    }

    public AttributeMapBindingListener getListener() {
        return this.listener;
    }

    public Map<String, Object> getSessionMap() {
        return this.sessionMap;
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.listener.valueBound(this.getContextBindingEvent(event));
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.listener.valueUnbound(this.getContextBindingEvent(event));
    }

    private AttributeMapBindingEvent getContextBindingEvent(HttpSessionBindingEvent event) {
        return new AttributeMapBindingEvent(new LocalAttributeMap<Object>(this.sessionMap), event.getName(), this.listener);
    }
}

