/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script.groovy;

import groovy.grape.GrabAnnotationTransformation;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.blacklists.Blacklist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.RejectASTTransformsCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class GroovyScriptExecutorFactory
extends ScriptExecutorFactory {
    private static final Log LOG = Log.getLog(GroovyScriptExecutorFactory.class);
    private static final CompilerConfiguration CC = new CompilerConfiguration();
    private static Object BLACKLIST;

    public ScriptExecutor newScriptExecutor(ClassLoader loader, String script, boolean compile) {
        return new GroovyScriptExecutor(loader, script);
    }

    public String getLanguageName() {
        return "Groovy";
    }

    static {
        try {
            CC.addCompilationCustomizers(new CompilationCustomizer[]{new RejectASTTransformsCustomizer(), new SandboxTransformer()});
            CC.setDisabledGlobalASTTransformations(Collections.singleton(GrabAnnotationTransformation.class.getName()));
            try (InputStream in = GroovyScriptExecutorFactory.class.getClassLoader().getResourceAsStream("META-INF/groovy.blacklist");
                 InputStreamReader reader = new InputStreamReader(in);){
                BLACKLIST = new Blacklist((Reader)reader);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load META-INF/groovy.blacklist", e);
            }
        }
        catch (NoClassDefFoundError noClassDefFound) {
            LOG.warn((Throwable)noClassDefFound, "Groovy Sandbox runtime not found, disabling", new Object[0]);
            BLACKLIST = null;
        }
    }

    private static class GroovyScriptExecutor
    implements ScriptExecutor {
        private final Script groovyScript;

        public GroovyScriptExecutor(ClassLoader loader, String script) {
            this.groovyScript = new GroovyShell(loader, CC).parse(script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Map<String, Object> arguments) throws Exception {
            SandboxInterceptor interceptor = null;
            try {
                interceptor = new SandboxInterceptor((Whitelist)BLACKLIST);
                ((GroovyInterceptor)interceptor).register();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                this.groovyScript.setBinding(new Binding(CollectionUtil.nullAsEmpty(arguments)));
                Object object = this.groovyScript.run();
                return object;
            }
            finally {
                if (interceptor != null) {
                    try {
                        ((GroovyInterceptor)interceptor).unregister();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
            }
        }
    }
}

