/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;

public enum HtmlTextEscapingMode {
    PCDATA,
    CDATA,
    CDATA_SOMETIMES,
    RCDATA,
    PLAIN_TEXT,
    VOID;

    private static final ImmutableMap<String, HtmlTextEscapingMode> ESCAPING_MODES;

    public static HtmlTextEscapingMode getModeForTag(String canonTagName) {
        HtmlTextEscapingMode mode = (HtmlTextEscapingMode)((Object)ESCAPING_MODES.get((Object)canonTagName));
        return mode != null ? mode : PCDATA;
    }

    public static boolean isTagFollowedByLiteralContent(String canonTagName) {
        HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(canonTagName);
        return mode != PCDATA && mode != VOID;
    }

    public static boolean isVoidElement(String canonTagName) {
        return HtmlTextEscapingMode.getModeForTag(canonTagName) == VOID;
    }

    static {
        ESCAPING_MODES = ImmutableMap.builder().put((Object)"iframe", (Object)CDATA).put((Object)"listing", (Object)CDATA_SOMETIMES).put((Object)"xmp", (Object)CDATA).put((Object)"comment", (Object)CDATA_SOMETIMES).put((Object)"plaintext", (Object)PLAIN_TEXT).put((Object)"script", (Object)CDATA).put((Object)"style", (Object)CDATA).put((Object)"textarea", (Object)RCDATA).put((Object)"title", (Object)RCDATA).put((Object)"area", (Object)VOID).put((Object)"base", (Object)VOID).put((Object)"br", (Object)VOID).put((Object)"col", (Object)VOID).put((Object)"command", (Object)VOID).put((Object)"embed", (Object)VOID).put((Object)"hr", (Object)VOID).put((Object)"img", (Object)VOID).put((Object)"input", (Object)VOID).put((Object)"keygen", (Object)VOID).put((Object)"link", (Object)VOID).put((Object)"meta", (Object)VOID).put((Object)"param", (Object)VOID).put((Object)"source", (Object)VOID).put((Object)"track", (Object)VOID).put((Object)"wbr", (Object)VOID).put((Object)"basefont", (Object)VOID).put((Object)"isindex", (Object)VOID).build();
    }
}

