/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.SignRequest;
import com.yubico.u2f.data.messages.SignRequestData;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.U2FAuthentication;
import org.apereo.cas.adaptors.u2f.U2FMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class U2FStartAuthenticationAction
extends AbstractMultifactorAuthenticationAction<U2FMultifactorAuthenticationProvider> {
    private final U2F u2f;
    private final String serverAddress;
    private final U2FDeviceRepository u2FDeviceRepository;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Principal p = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal());
        List registeredDevices = this.u2FDeviceRepository.getRegisteredDevices(p.getId()).stream().map(arg_0 -> ((U2FDeviceRepository)this.u2FDeviceRepository).decode(arg_0)).map(Unchecked.function(r -> DeviceRegistration.fromJson((String)r.getRecord()))).filter(Objects::nonNull).collect(Collectors.toList());
        SignRequestData requestData = this.u2f.startSignature(this.serverAddress, registeredDevices);
        this.u2FDeviceRepository.requestDeviceAuthentication(requestData.getRequestId(), p.getId(), requestData.toJson());
        if (!requestData.getSignRequests().isEmpty()) {
            SignRequest req = (SignRequest)requestData.getSignRequests().get(0);
            U2FAuthentication u2fAuth = new U2FAuthentication(req.getChallenge(), req.getAppId(), req.getKeyHandle());
            requestContext.getFlowScope().put("u2fAuth", (Object)u2fAuth);
            return this.success();
        }
        return this.error();
    }

    @Generated
    public U2FStartAuthenticationAction(U2F u2f, String serverAddress, U2FDeviceRepository u2FDeviceRepository) {
        this.u2f = u2f;
        this.serverAddress = serverAddress;
        this.u2FDeviceRepository = u2FDeviceRepository;
    }
}

