/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import lombok.Generated;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.data.annotation.Id;

@MappedSuperclass
@JsonIgnoreProperties(ignoreUnknown=true)
public class MultifactorAuthenticationTrustRecord
implements Comparable<MultifactorAuthenticationTrustRecord>,
Serializable {
    private static final int YEARS_TO_KEEP_RECORD_AS_FOREVER = 100;
    private static final long serialVersionUID = -5263885151448276769L;
    @Id
    @Transient
    @JsonProperty(value="id")
    private long id = -1L;
    @Column(nullable=false)
    @JsonProperty(value="principal")
    private String principal;
    @JsonProperty(value="deviceFingerprint")
    @Column(nullable=false, length=2048, name="deviceFingerprint")
    private String deviceFingerprint;
    @JsonProperty(value="recordDate")
    @Column(name="recordDate", nullable=false, columnDefinition="timestamp")
    private ZonedDateTime recordDate = ZonedDateTime.now(ZoneOffset.UTC);
    @JsonProperty(value="recordKey")
    @Column(name="recordKey", length=4000, nullable=false)
    private String recordKey;
    @JsonProperty(value="name")
    @Column(name="recordName", length=4000, nullable=false)
    private String name;
    @JsonProperty(value="expirationDate")
    @Column(name="expirationDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expirationDate;

    public MultifactorAuthenticationTrustRecord() {
        this.id = System.currentTimeMillis();
    }

    public static MultifactorAuthenticationTrustRecord newInstance(String principal, String geography, String fingerprint) {
        MultifactorAuthenticationTrustRecord r = new MultifactorAuthenticationTrustRecord();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        r.setRecordDate(now.truncatedTo(ChronoUnit.SECONDS));
        r.setPrincipal(principal);
        r.setDeviceFingerprint(fingerprint);
        r.setName(principal.concat("-").concat(now.toString()).concat("-").concat(geography));
        r.neverExpire();
        return r;
    }

    @JsonIgnore
    public boolean isExpired() {
        ZonedDateTime zonedExpDate;
        if (this.expirationDate == null) {
            return false;
        }
        ZonedDateTime expDate = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
        return expDate.equals(zonedExpDate = DateTimeUtils.zonedDateTimeOf((Date)this.expirationDate).truncatedTo(ChronoUnit.SECONDS)) || expDate.isAfter(zonedExpDate);
    }

    public void expireIn(long expiration, ChronoUnit timeUnit) {
        ZonedDateTime expDate = ZonedDateTime.now(ZoneOffset.UTC).plus(expiration, timeUnit).truncatedTo(ChronoUnit.SECONDS);
        Date zonedExpDate = DateTimeUtils.dateOf((ChronoZonedDateTime)expDate);
        this.setExpirationDate(zonedExpDate);
    }

    @Override
    public int compareTo(MultifactorAuthenticationTrustRecord o) {
        return this.recordDate.compareTo(o.getRecordDate());
    }

    @JsonIgnore
    public void neverExpire() {
        ZonedDateTime expDate = this.getRecordDate().plusYears(100L).truncatedTo(ChronoUnit.SECONDS);
        Date zonedExpDate = DateTimeUtils.dateOf((ChronoZonedDateTime)expDate);
        this.setExpirationDate(zonedExpDate);
    }

    @Generated
    public String toString() {
        return "MultifactorAuthenticationTrustRecord(id=" + this.id + ", principal=" + this.principal + ", deviceFingerprint=" + this.deviceFingerprint + ", recordDate=" + this.recordDate + ", recordKey=" + this.recordKey + ", name=" + this.name + ", expirationDate=" + this.expirationDate + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @Generated
    public ZonedDateTime getRecordDate() {
        return this.recordDate;
    }

    @Generated
    public String getRecordKey() {
        return this.recordKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="principal")
    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @JsonProperty(value="deviceFingerprint")
    @Generated
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    @JsonProperty(value="recordDate")
    @Generated
    public void setRecordDate(ZonedDateTime recordDate) {
        this.recordDate = recordDate;
    }

    @JsonProperty(value="recordKey")
    @Generated
    public void setRecordKey(String recordKey) {
        this.recordKey = recordKey;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="expirationDate")
    @Generated
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultifactorAuthenticationTrustRecord)) {
            return false;
        }
        MultifactorAuthenticationTrustRecord other = (MultifactorAuthenticationTrustRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        String this$principal = this.principal;
        String other$principal = other.principal;
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$deviceFingerprint = this.deviceFingerprint;
        String other$deviceFingerprint = other.deviceFingerprint;
        if (this$deviceFingerprint == null ? other$deviceFingerprint != null : !this$deviceFingerprint.equals(other$deviceFingerprint)) {
            return false;
        }
        ZonedDateTime this$recordDate = this.recordDate;
        ZonedDateTime other$recordDate = other.recordDate;
        if (this$recordDate == null ? other$recordDate != null : !((Object)this$recordDate).equals(other$recordDate)) {
            return false;
        }
        String this$recordKey = this.recordKey;
        String other$recordKey = other.recordKey;
        if (this$recordKey == null ? other$recordKey != null : !this$recordKey.equals(other$recordKey)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$expirationDate = this.expirationDate;
        Date other$expirationDate = other.expirationDate;
        return !(this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultifactorAuthenticationTrustRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.id;
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $deviceFingerprint = this.deviceFingerprint;
        result = result * 59 + ($deviceFingerprint == null ? 43 : $deviceFingerprint.hashCode());
        ZonedDateTime $recordDate = this.recordDate;
        result = result * 59 + ($recordDate == null ? 43 : ((Object)$recordDate).hashCode());
        String $recordKey = this.recordKey;
        result = result * 59 + ($recordKey == null ? 43 : $recordKey.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $expirationDate = this.expirationDate;
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        return result;
    }
}

