/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.weibo;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.weibo.WeiboProfile;
import org.pac4j.scribe.model.WeiboToken;

public class WeiboProfileDefinition
extends OAuthProfileDefinition {
    public static final String ID = "id";
    public static final String IDSTR = "idstr";
    public static final String SCREEN_NAME = "screen_name";
    public static final String NAME = "name";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";
    public static final String LOCATION = "location";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";
    public static final String PROFILE_IMAGE_URL = "profile_image_url";
    public static final String COVER_IMAGE_PHONE = "cover_image_phone";
    public static final String PROFILE_URL = "profile_url";
    public static final String DOMAIN = "domain";
    public static final String WEIHAO = "weihao";
    public static final String GENDER = "gender";
    public static final String FOLLOWERS_COUNT = "followers_count";
    public static final String FRIENDS_COUNT = "friends_count";
    public static final String STATUSES_COUNT = "statuses_count";
    public static final String FAVOURITES_COUNT = "favourites_count";
    public static final String CREATED_AT = "created_at";
    public static final String FOLLOWING = "following";
    public static final String ALLOW_ALL_ACT_MSG = "allow_all_act_msg";
    public static final String GEO_ENABLED = "geo_enabled";
    public static final String VERIFIED = "verified";
    public static final String VERIFIED_TYPE = "verified_type";
    public static final String REMARK = "remark";
    public static final String STATUS = "status";
    public static final String ALLOW_ALL_COMMENT = "allow_all_comment";
    public static final String AVATAR_LARGE = "avatar_large";
    public static final String AVATAR_HD = "avatar_hd";
    public static final String VERIFIED_REASON = "verified_reason";
    public static final String FOLLOW_ME = "follow_me";
    public static final String ONLINE_STATUS = "online_status";
    public static final String BI_FOLLOWERS_COUNT = "bi_followers_count";
    public static final String LANG = "lang";

    public WeiboProfileDefinition() {
        Arrays.stream(new String[]{URL, PROFILE_IMAGE_URL, COVER_IMAGE_PHONE, PROFILE_URL, AVATAR_LARGE, AVATAR_HD}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.URL));
        Arrays.stream(new String[]{IDSTR, SCREEN_NAME, NAME, LOCATION, DESCRIPTION, DOMAIN, WEIHAO, CREATED_AT, REMARK, VERIFIED_REASON}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        Arrays.stream(new String[]{FOLLOWING, ALLOW_ALL_ACT_MSG, GEO_ENABLED, VERIFIED, ALLOW_ALL_COMMENT, FOLLOW_ME}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.BOOLEAN));
        Arrays.stream(new String[]{PROVINCE, CITY, FOLLOWERS_COUNT, FRIENDS_COUNT, STATUSES_COUNT, FAVOURITES_COUNT, VERIFIED_TYPE, ONLINE_STATUS, BI_FOLLOWERS_COUNT}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.INTEGER));
        this.primary(ID, (AttributeConverter)Converters.LONG);
        this.primary(LANG, (AttributeConverter)Converters.LOCALE);
        this.primary(GENDER, (AttributeConverter)Converters.GENDER);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        if (accessToken instanceof WeiboToken) {
            return CommonHelper.addParameter((String)"https://api.weibo.com/2/users/show.json", (String)"uid", (String)((WeiboToken)accessToken).getUid());
        }
        throw new OAuthException("Token in getProfileUrl is not an WeiboToken");
    }

    @Override
    public WeiboProfile extractUserProfile(String body) throws HttpAction {
        WeiboProfile profile = new WeiboProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, ID)));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

