/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap();

    public MockMultipartHttpServletRequest() {
        this(null);
    }

    public MockMultipartHttpServletRequest(@Nullable ServletContext servletContext) {
        super(servletContext);
        this.setMethod("POST");
        this.setContentType("multipart/form-data");
    }

    public void addFile(MultipartFile file) {
        Assert.notNull((Object)file, (String)"MultipartFile must not be null");
        this.multipartFiles.add((Object)file.getName(), (Object)file);
    }

    public Iterator<String> getFileNames() {
        return this.multipartFiles.keySet().iterator();
    }

    @Nullable
    public MultipartFile getFile(String name) {
        return (MultipartFile)this.multipartFiles.getFirst((Object)name);
    }

    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get((Object)name);
        return Objects.requireNonNullElse(multipartFiles, Collections.emptyList());
    }

    public Map<String, MultipartFile> getFileMap() {
        return this.multipartFiles.asSingleValueMap();
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap(this.multipartFiles);
    }

    @Nullable
    public String getMultipartContentType(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            return file.getContentType();
        }
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                return part.getContentType();
            }
        }
        catch (ServletException | IOException ex) {
            throw new IllegalStateException(ex);
        }
        return null;
    }

    public HttpMethod getRequestMethod() {
        String method = this.getMethod();
        Assert.state((method != null ? 1 : 0) != 0, (String)"Method must not be null");
        return HttpMethod.valueOf((String)method);
    }

    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            headers.put(headerName, Collections.list(this.getHeaders(headerName)));
        }
        return headers;
    }

    @Nullable
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            HttpHeaders headers = new HttpHeaders();
            if (file.getContentType() != null) {
                headers.add("Content-Type", file.getContentType());
            }
            return headers;
        }
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                HttpHeaders headers = new HttpHeaders();
                for (String headerName : part.getHeaderNames()) {
                    headers.put(headerName, new ArrayList(part.getHeaders(headerName)));
                }
                return headers;
            }
        }
        catch (Throwable ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
        return null;
    }
}

