/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.read.CyclicBufferAppender;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.junit.runner.Description;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Component(immediate=true, property={"servlet.path=/system/sling/testlog", "log.buffer.size:Integer=1000", "logPattern=%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n"})
public class TestLogServlet
extends HttpServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String TEST_NAME = "X-Sling-TestName";
    public static final String TEST_CLASS = "X-Sling-TestClass";
    public static final String SERVLET_PATH_NAME = "servlet.path";
    public static final int DEFAULT_SIZE = 1000;
    public static final String LOG_BUFFER_SIZE = "log.buffer.size";
    public static final String DEFAULT_PATTERN = "%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n";
    public static final String PROP_MSG_PATTERN = "logPattern";
    private String servletPath;
    @Reference
    private HttpService httpService;
    private CyclicBufferAppender<ILoggingEvent> appender;
    private Layout<ILoggingEvent> layout;
    private ServiceRegistration filter;
    private volatile Description currentTest;
    private final Object appenderLock = new Object();

    @Activate
    protected void activate(BundleContext ctx, Map<String, ?> config) throws Exception {
        this.registerServlet(config);
        this.registerAppender(config);
        this.registerFilter(ctx);
        this.createLayout(config);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.deregisterFilter();
        this.deregisterServlet();
        this.deregisterAppender();
        this.stopLayout();
    }

    public void testRunStarted(Description description) {
        if (description != null && !description.equals(this.currentTest)) {
            this.currentTest = description;
            this.resetAppender();
            this.log.info("Starting test execution ======[{}]======", (Object)description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Description expected;
        PrintWriter pw = response.getWriter();
        String className = request.getParameter(TEST_CLASS);
        String testName = request.getParameter(TEST_NAME);
        if (className != null && testName != null && !(expected = Description.createTestDescription(className, testName, new Annotation[0])).equals(this.currentTest)) {
            pw.printf("Test name mismatch : Current test [%s], Expected test [%s]%n", this.currentTest, expected);
            return;
        }
        TestLogServlet.rootLogger().detachAppender(this.appender);
        try {
            for (int i = 0; i < this.appender.getLength(); ++i) {
                pw.print(this.layout.doLayout((Object)((ILoggingEvent)this.appender.get(i))));
            }
            this.resetAppender();
        }
        finally {
            TestLogServlet.rootLogger().addAppender(this.appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAppender() {
        Object object = this.appenderLock;
        synchronized (object) {
            if (this.appender.isStarted()) {
                this.appender.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAppender(Map<String, ?> config) {
        Object object = this.appenderLock;
        synchronized (object) {
            int size = PropertiesUtil.toInteger(config.get(LOG_BUFFER_SIZE), (int)1000);
            this.appender = new CyclicBufferAppender();
            this.appender.setMaxSize(size);
            this.appender.setContext((Context)TestLogServlet.getContext());
            this.appender.setName("TestLogCollector");
            this.appender.start();
            TestLogServlet.rootLogger().addAppender(this.appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterAppender() {
        if (this.appender != null) {
            Object object = this.appenderLock;
            synchronized (object) {
                TestLogServlet.rootLogger().detachAppender(this.appender);
                this.appender.stop();
                this.appender = null;
            }
        }
    }

    private void createLayout(Map<String, ?> config) {
        String pattern = PropertiesUtil.toString(config.get(PROP_MSG_PATTERN), (String)DEFAULT_PATTERN);
        PatternLayout pl = new PatternLayout();
        pl.setPattern(pattern);
        pl.setOutputPatternAsHeader(false);
        pl.setContext((Context)TestLogServlet.getContext());
        pl.start();
        this.layout = pl;
    }

    private void stopLayout() {
        if (this.layout != null) {
            this.layout.stop();
        }
    }

    private void registerServlet(Map<String, ?> config) throws ServletException, NamespaceException {
        this.servletPath = TestLogServlet.getServletPath(config);
        if (this.servletPath == null) {
            this.log.info("Servlet path is null, not registering with HttpService");
        } else {
            this.httpService.registerServlet(this.servletPath, (Servlet)this, null, null);
            this.log.info("Servlet registered at {}", (Object)this.servletPath);
        }
    }

    private void deregisterServlet() {
        if (this.servletPath != null) {
            this.httpService.unregister(this.servletPath);
            this.log.info("Servlet unregistered from path {}", (Object)this.servletPath);
        }
        this.servletPath = null;
    }

    private void registerFilter(BundleContext ctx) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Filter to extract testName from request headers");
        props.put("service.vendor", (String)ctx.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("osgi.http.whiteboard.filter.pattern", "/");
        props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
        this.filter = ctx.registerService(Filter.class.getName(), (Object)new TestNameLoggingFilter(), props);
    }

    private void deregisterFilter() {
        if (this.filter != null) {
            this.filter.unregister();
        }
    }

    private static String getServletPath(Map<String, ?> config) {
        String result = (String)config.get(SERVLET_PATH_NAME);
        if (result != null && result.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    private static LoggerContext getContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    private static ch.qos.logback.classic.Logger rootLogger() {
        return TestLogServlet.getContext().getLogger("ROOT");
    }

    private class TestNameLoggingFilter
    implements Filter {
        private TestNameLoggingFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String className = httpRequest.getHeader(TestLogServlet.TEST_CLASS);
            String testName = httpRequest.getHeader(TestLogServlet.TEST_NAME);
            if (className == null || testName == null) {
                chain.doFilter(request, response);
                return;
            }
            try {
                MDC.put((String)TestLogServlet.TEST_NAME, (String)testName);
                MDC.put((String)TestLogServlet.TEST_CLASS, (String)className);
                TestLogServlet.this.testRunStarted(Description.createTestDescription(className, testName, new Annotation[0]));
                chain.doFilter(request, response);
            }
            finally {
                MDC.remove((String)TestLogServlet.TEST_NAME);
                MDC.remove((String)TestLogServlet.TEST_CLASS);
            }
        }

        public void destroy() {
        }
    }
}

