/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.nodetype;

import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.Value;
import relocated_for_contentpackage.javax.jcr.nodetype.ConstraintViolationException;
import relocated_for_contentpackage.javax.jcr.nodetype.PropertyDefinition;
import relocated_for_contentpackage.javax.jcr.nodetype.PropertyDefinitionTemplate;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.query.qom.Operator;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.nodetype.AbstractItemDefinitionTemplate;

class PropertyDefinitionTemplateImpl
extends AbstractItemDefinitionTemplate
implements PropertyDefinitionTemplate {
    private int type;
    private String[] constraints;
    private Value[] defaultValues;
    private boolean multiple;
    private boolean fullTextSearchable;
    private boolean queryOrderable;
    private String[] queryOperators;

    PropertyDefinitionTemplateImpl(NamePathResolver resolver) {
        super(resolver);
        this.type = 1;
        this.fullTextSearchable = true;
        this.queryOrderable = true;
        this.queryOperators = Operator.getAllQueryOperators();
    }

    PropertyDefinitionTemplateImpl(PropertyDefinition def, NamePathResolver resolver) throws ConstraintViolationException {
        super(def, resolver);
        this.type = def.getRequiredType();
        this.defaultValues = def.getDefaultValues();
        this.multiple = def.isMultiple();
        this.fullTextSearchable = def.isFullTextSearchable();
        this.queryOrderable = def.isQueryOrderable();
        this.queryOperators = def.getAvailableQueryOperators();
        this.setValueConstraints(def.getValueConstraints());
    }

    @Override
    public void setRequiredType(int type) {
        PropertyType.nameFromValue(type);
        this.type = type;
    }

    @Override
    public void setValueConstraints(String[] constraints) {
        this.constraints = constraints;
    }

    @Override
    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public void setAvailableQueryOperators(String[] operators) {
        this.queryOperators = operators;
    }

    @Override
    public void setFullTextSearchable(boolean searchable) {
        this.fullTextSearchable = searchable;
    }

    @Override
    public void setQueryOrderable(boolean orderable) {
        this.queryOrderable = orderable;
    }

    @Override
    public int getRequiredType() {
        return this.type;
    }

    @Override
    public String[] getValueConstraints() {
        return this.constraints;
    }

    @Override
    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public String[] getAvailableQueryOperators() {
        return this.queryOperators;
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    @Override
    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }
}

