/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.io.Closeable;
import java.util.Hashtable;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.impl.discovery.DiscoveryService;
import org.apache.sling.distribution.journal.impl.publisher.MessagingCacheCallback;
import org.apache.sling.distribution.journal.impl.publisher.PublishMetrics;
import org.apache.sling.distribution.journal.messages.ClearCommand;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.journal.queue.PubQueueProvider;
import org.apache.sling.distribution.journal.queue.PubQueueProviderFactory;
import org.apache.sling.distribution.journal.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class PubQueueProviderPublisher {
    private PubQueueProvider pubQueueProvider;
    private Closeable statusPoller;
    private ServiceRegistration<?> reg;

    @Activate
    public PubQueueProviderPublisher(@Reference MessagingProvider messagingProvider, @Reference DiscoveryService discoveryService, @Reference Topics topics, @Reference MetricsService metricsService, @Reference PubQueueProviderFactory pubQueueProviderFactory, BundleContext context) {
        PublishMetrics publishMetrics = new PublishMetrics(metricsService, "");
        MessageSender commandSender = messagingProvider.createSender(topics.getCommandTopic());
        MessagingCacheCallback callback = new MessagingCacheCallback(messagingProvider, topics.getPackageTopic(), publishMetrics, discoveryService, (Consumer<ClearCommand>)commandSender);
        this.pubQueueProvider = pubQueueProviderFactory.create(callback);
        HandlerAdapter[] handlerAdapterArray = new HandlerAdapter[1];
        handlerAdapterArray[0] = HandlerAdapter.create(PackageStatusMessage.class, this.pubQueueProvider::handleStatus);
        this.statusPoller = messagingProvider.createPoller(topics.getStatusTopic(), Reset.earliest, handlerAdapterArray);
        this.reg = context.registerService(PubQueueProvider.class, (Object)this.pubQueueProvider, new Hashtable());
    }

    @Deactivate
    public void deactivate() {
        IOUtils.closeQuietly((Closeable[])new Closeable[]{this.statusPoller, this.pubQueueProvider});
        this.reg.unregister();
    }
}

