/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.api.wrappers.impl.ObjectConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public interface ValueMap
extends Map<String, Object> {
    public static final ValueMap EMPTY = new ValueMapDecorator(Collections.emptyMap());

    @Nullable
    default public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return ObjectConverter.convert(value, type);
    }

    @NotNull
    default public <T> T get(@NotNull String name, @NotNull T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }
}

