/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.solution.basic.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.provider.OpenAPIRegistry;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.router.util.VersionCompareUtil;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class InstanceOpenAPIRegistry
implements OpenAPIRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceOpenAPIRegistry.class);
    private DiscoveryManager discoveryManager;
    private Environment environment;
    private TransportManager transportManager;

    @Autowired
    public void setDiscoveryManager(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Autowired
    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty("servicecomb.openAPI.registry.instance.enabled", Boolean.TYPE, (Object)true);
    }

    public void registerOpenAPI(String application, String serviceName, String schemaId, OpenAPI api) {
    }

    public Map<String, OpenAPI> loadOpenAPI(String application, String serviceName) {
        List discoveryInstances = (List)this.discoveryManager.getOrCreateVersionedCache(application, serviceName).data();
        if (discoveryInstances.isEmpty()) {
            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "no instances");
        }
        discoveryInstances.sort((a, b) -> VersionCompareUtil.compareVersion((String)b.getVersion(), (String)a.getVersion()));
        String version = null;
        for (DiscoveryInstance instance : discoveryInstances) {
            if (version != null && !version.equals(instance.getVersion())) break;
            version = instance.getVersion();
            for (String endpoint : instance.getEndpoints()) {
                URI uri = URI.create(endpoint);
                String transportName = uri.getScheme();
                Transport transport = this.transportManager.findTransport(transportName);
                if (transport == null) continue;
                Invocation invocation = InvokerUtils.createInvocation((String)BootStrapProperties.readServiceName((Environment)this.environment), (String)transportName, (String)"scb-management", (String)"schemaContents", new HashMap(), (Type)new TypeReference<Map<String, String>>(){}.getType());
                invocation.setEndpoint(new Endpoint(transport, endpoint, (DiscoveryInstance)discoveryInstances.get(0)));
                try {
                    Map contents = (Map)InvokerUtils.syncInvoke((Invocation)invocation);
                    HashMap<String, OpenAPI> result = new HashMap<String, OpenAPI>(contents.size());
                    contents.forEach((k, v) -> result.put((String)k, SwaggerUtils.parseSwagger((String)v)));
                    return result;
                }
                catch (InvocationException e) {
                    LOGGER.warn("Get schema contents {}/{}/{} from endpoint {} failed. {}", new Object[]{instance.getApplication(), instance.getServiceName(), instance.getInstanceId(), endpoint, e.getMessage()});
                }
            }
        }
        throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Get schema contents fail from all latest version.");
    }

    public void setOpenAPIChangeListener(OpenAPIRegistryManager.OpenAPIChangeListener listener) {
        this.discoveryManager.addInstanceChangeListener((registryName, application, serviceName, instances) -> {
            if (CollectionUtils.isEmpty((Collection)instances)) {
                return;
            }
            listener.onOpenAPIChanged(application, serviceName);
        });
    }

    public int getOrder() {
        return -9000;
    }
}

