/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.marker.operator;

import java.util.HashSet;
import java.util.Set;
import org.apache.servicecomb.governance.exception.IllegalArgsOperatorException;
import org.apache.servicecomb.governance.marker.operator.MatchOperator;

public class CompareOperator
implements MatchOperator {
    private final Set<Character> charSet = new HashSet<Character>();

    public CompareOperator() {
        this.charSet.add(Character.valueOf('>'));
        this.charSet.add(Character.valueOf('<'));
        this.charSet.add(Character.valueOf('='));
        this.charSet.add(Character.valueOf('!'));
    }

    @Override
    public String name() {
        return "compare";
    }

    @Override
    public boolean match(String targetStr, String patternStr) {
        char[] chars = patternStr.toCharArray();
        if (this.isLegalChar(chars[0]) && this.isLegalChar(chars[1])) {
            return this.process(targetStr, patternStr.substring(0, 2), patternStr.substring(2));
        }
        if (this.isLegalChar(chars[0])) {
            return this.process(targetStr, patternStr.substring(0, 1), patternStr.substring(1));
        }
        throw new IllegalArgsOperatorException("operator " + patternStr + " is illegal.");
    }

    private boolean process(String targetStr, String charStr, String numStr) {
        double result;
        double target;
        try {
            target = Double.parseDouble(targetStr);
            result = numStr.startsWith("-") ? -Double.parseDouble(numStr.substring(1)) : Double.parseDouble(numStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgsOperatorException("operator " + charStr + numStr + " is illegal.");
        }
        switch (charStr) {
            case ">": {
                return target > result;
            }
            case "<": {
                return target < result;
            }
            case "=": {
                return this.doubleEquals(target, result);
            }
            case ">=": {
                return target >= result;
            }
            case "<=": {
                return target <= result;
            }
            case "!": 
            case "!=": {
                return !this.doubleEquals(target, result);
            }
        }
        throw new IllegalArgsOperatorException("operator " + charStr + numStr + " is illegal.");
    }

    private boolean isLegalChar(char c) {
        return this.charSet.contains(Character.valueOf(c));
    }

    private boolean doubleEquals(double target, double result) {
        return Math.abs(target - result) < 1.0E-6;
    }
}

