/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.ext.web.FileUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.foundation.common.part.AbstractPart;

public class FileUploadPart
extends AbstractPart {
    private final FileUpload fileUpload;

    public FileUploadPart(FileUpload fileUpload) {
        this.fileUpload = fileUpload;
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(new File(this.fileUpload.uploadedFileName()).toPath(), new OpenOption[0]);
    }

    public String getContentType() {
        return this.fileUpload.contentType();
    }

    public String getName() {
        return this.fileUpload.name();
    }

    public String getSubmittedFileName() {
        return this.fileUpload.fileName();
    }

    public long getSize() {
        return this.fileUpload.size();
    }

    public void write(String fileName) throws IOException {
        FileUtils.copyFile((File)new File(this.fileUpload.uploadedFileName()), (File)new File(fileName));
    }
}

