/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.Json;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.RestVertxProducerInvocationCreator;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerWebSocketInvocationCreator
implements InvocationCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestVertxProducerInvocationCreator.class);
    protected MicroserviceMeta microserviceMeta;
    protected final Endpoint endpoint;
    protected final ServerWebSocket websocket;
    protected RestOperationMeta restOperationMeta;

    public ServerWebSocketInvocationCreator(MicroserviceMeta microserviceMeta, Endpoint endpoint, ServerWebSocket websocket) {
        this.microserviceMeta = microserviceMeta;
        this.endpoint = endpoint;
        this.websocket = websocket;
    }

    public CompletableFuture<Invocation> createAsync() {
        this.initRestOperation();
        Invocation invocation = this.createInstance();
        this.initInvocationContext(invocation);
        this.addParameterContext(invocation);
        this.initTransportContext(invocation);
        return CompletableFuture.completedFuture(invocation);
    }

    protected Invocation createInstance() {
        return InvocationFactory.forProvider((Endpoint)this.endpoint, (OperationMeta)this.restOperationMeta.getOperationMeta(), null);
    }

    protected void initInvocationContext(Invocation invocation) {
        if (!LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.context.decodeInvocationContext", (boolean)true)) {
            return;
        }
        String strCseContext = this.websocket.headers().get("x-cse-context");
        if (StringUtils.isEmpty((CharSequence)strCseContext)) {
            return;
        }
        Map invocationContext = (Map)Json.decodeValue((String)strCseContext, Map.class);
        invocation.mergeContext(invocationContext);
    }

    protected void addParameterContext(Invocation invocation) {
        String headerContextMapper = LegacyPropertyFactory.getStringProperty((String)"servicecomb.context.headerContextMapper");
        HashMap<String, Object> headerContextMappers = headerContextMapper != null ? YAMLUtil.yaml2Properties((String)headerContextMapper) : new HashMap<String, Object>();
        headerContextMappers.forEach((k, v) -> {
            if (v instanceof String && this.websocket.headers().get(k) != null) {
                invocation.addContext((String)v, this.websocket.headers().get(k));
            }
        });
    }

    protected abstract void initTransportContext(Invocation var1);

    protected void initRestOperation() {
        OperationLocator locator = this.locateOperation(this.microserviceMeta);
        this.restOperationMeta = locator.getOperation();
    }

    protected OperationLocator locateOperation(MicroserviceMeta microserviceMeta) {
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager(microserviceMeta);
        if (servicePathManager == null) {
            LOGGER.error("No schema defined for {}:{}.", (Object)this.microserviceMeta.getAppId(), (Object)this.microserviceMeta.getMicroserviceName());
            throw Exceptions.create((Response.StatusType)Response.Status.NOT_FOUND, (String)"SCB.00000002", (String)Response.Status.NOT_FOUND.getReasonPhrase());
        }
        return this.locateOperation(servicePathManager);
    }

    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.producerLocateOperation(this.websocket.path(), HttpMethod.POST.name());
    }
}

