/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.foundation.common.http.HttpUtils;
import org.apache.servicecomb.foundation.common.part.AbstractPart;
import org.apache.servicecomb.foundation.vertx.stream.PumpCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadStreamPart
extends AbstractPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadStreamPart.class);
    private final Context context;
    private final ReadStream<Buffer> readStream;

    public ReadStreamPart(Context context, HttpClientResponse httpClientResponse) {
        this(context, (ReadStream<Buffer>)httpClientResponse);
        this.setSubmittedFileName(HttpUtils.parseFileNameFromHeaderValue((String)httpClientResponse.getHeader("Content-Disposition")));
        String contentType = httpClientResponse.getHeader("Content-Type");
        if (StringUtils.isNotEmpty((String)contentType)) {
            this.contentType(contentType);
        }
    }

    public ReadStreamPart(Context context, ReadStream<Buffer> readStream) {
        this.context = context;
        this.readStream = readStream;
        readStream.pause();
    }

    public Context getContext() {
        return this.context;
    }

    public ReadStream<Buffer> getReadStream() {
        return this.readStream;
    }

    public CompletableFuture<Void> saveToWriteStream(WriteStream<Buffer> writeStream) {
        return new PumpCommon().pump(this.context, this.readStream, writeStream, null);
    }

    public CompletableFuture<byte[]> saveAsBytes() {
        return this.saveAs(Buffer::getBytes);
    }

    public CompletableFuture<String> saveAsString() {
        return this.saveAs(Buffer::toString);
    }

    public <T> CompletableFuture<T> saveAs(Function<Buffer, T> converter) {
        CompletableFuture future = new CompletableFuture();
        Buffer buffer = Buffer.buffer();
        this.context.runOnContext(V -> {
            this.readStream.exceptionHandler(future::completeExceptionally);
            this.readStream.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
            this.readStream.endHandler(v -> future.complete(converter.apply(buffer)));
            this.readStream.resume();
        });
        return future;
    }

    public CompletableFuture<File> saveToFile(String fileName) {
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        OpenOptions openOptions = new OpenOptions().setCreateNew(true);
        return this.saveToFile(file, openOptions);
    }

    public CompletableFuture<File> saveToFile(File file, OpenOptions openOptions) {
        CompletableFuture<File> future = new CompletableFuture<File>();
        this.context.runOnContext(v -> {
            Vertx vertx = this.context.owner();
            vertx.fileSystem().open(file.getAbsolutePath(), openOptions, ar -> this.onFileOpened(file, (AsyncResult<AsyncFile>)ar, future));
        });
        return future;
    }

    protected void onFileOpened(File file, AsyncResult<AsyncFile> ar, CompletableFuture<File> future) {
        if (ar.failed()) {
            future.completeExceptionally(ar.cause());
            return;
        }
        AsyncFile asyncFile = (AsyncFile)ar.result();
        CompletableFuture<Void> saveFuture = this.saveToWriteStream((WriteStream<Buffer>)asyncFile);
        saveFuture.whenComplete((v, saveException) -> asyncFile.close(closeAr -> {
            if (closeAr.failed()) {
                LOGGER.error("Failed to close file {}.", (Object)file);
            }
            if (saveException == null) {
                future.complete(file);
                return;
            }
            future.completeExceptionally((Throwable)saveException);
        }));
    }
}

