/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v2;

import com.alibaba.fastjson2.JSON;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.config.v2.ConfigStorage;
import org.apache.rocketmq.broker.config.v2.RecordPrefix;
import org.apache.rocketmq.broker.config.v2.SerializationType;
import org.apache.rocketmq.broker.config.v2.TableId;
import org.apache.rocketmq.broker.config.v2.TablePrefix;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

public class ConfigHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ByteBuf> loadDataVersion(ConfigStorage configStorage, TableId tableId) throws RocksDBException {
        int keyLen = 4 + ConfigStorage.DATA_VERSION_KEY_BYTES.length;
        ByteBuf keyBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        try {
            keyBuf.writeByte((int)TablePrefix.TABLE.getValue());
            keyBuf.writeShort((int)tableId.getValue());
            keyBuf.writeByte((int)RecordPrefix.DATA_VERSION.getValue());
            keyBuf.writeBytes(ConfigStorage.DATA_VERSION_KEY_BYTES);
            byte[] valueByes = configStorage.get(keyBuf.nioBuffer());
            if (null != valueByes) {
                ByteBuf valueBuf = Unpooled.wrappedBuffer((byte[])valueByes);
                Optional<ByteBuf> optional = Optional.of(valueBuf);
                return optional;
            }
        }
        finally {
            keyBuf.release();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stampDataVersion(WriteBatch writeBatch, TableId table, DataVersion dataVersion, long stateMachineVersion) throws RocksDBException {
        dataVersion.nextVersion(stateMachineVersion);
        int keyLen = 4 + ConfigStorage.DATA_VERSION_KEY_BYTES.length;
        ByteBuf keyBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        ByteBuf valueBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(24);
        try {
            keyBuf.writeByte((int)TablePrefix.TABLE.getValue());
            keyBuf.writeShort((int)table.getValue());
            keyBuf.writeByte((int)RecordPrefix.DATA_VERSION.getValue());
            keyBuf.writeBytes(ConfigStorage.DATA_VERSION_KEY_BYTES);
            valueBuf.writeLong(dataVersion.getStateVersion());
            valueBuf.writeLong(dataVersion.getTimestamp());
            valueBuf.writeLong(dataVersion.getCounter().get());
            writeBatch.put(keyBuf.nioBuffer(), valueBuf.nioBuffer());
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
    }

    public static void onDataVersionLoad(ByteBuf buf, DataVersion dataVersion) {
        if (buf.readableBytes() == 24) {
            long stateMachineVersion = buf.readLong();
            long timestamp = buf.readLong();
            long counter = buf.readLong();
            dataVersion.setStateVersion(stateMachineVersion);
            dataVersion.setTimestamp(timestamp);
            dataVersion.setCounter(new AtomicLong(counter));
        }
        buf.release();
    }

    public static ByteBuf keyBufOf(TableId tableId, String name) {
        Preconditions.checkNotNull((Object)name);
        byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
        int keyLen = 6 + bytes.length;
        ByteBuf keyBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        keyBuf.writeByte((int)TablePrefix.TABLE.getValue());
        keyBuf.writeShort((int)tableId.getValue());
        keyBuf.writeByte((int)RecordPrefix.DATA.getValue());
        keyBuf.writeShort(bytes.length);
        keyBuf.writeBytes(bytes);
        return keyBuf;
    }

    public static ByteBuf valueBufOf(Object config, SerializationType serializationType) {
        if (SerializationType.JSON == serializationType) {
            byte[] payload = JSON.toJSONBytes((Object)config);
            ByteBuf valueBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(1 + payload.length);
            valueBuf.writeByte((int)SerializationType.JSON.getValue());
            valueBuf.writeBytes(payload);
            return valueBuf;
        }
        throw new RuntimeException("Unsupported serialization type: " + (Object)((Object)serializationType));
    }

    public static byte[] readBytes(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }
}

