/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.auth.pipeline;

import io.netty.channel.ChannelHandlerContext;
import org.apache.rocketmq.auth.authentication.AuthenticationEvaluator;
import org.apache.rocketmq.auth.authentication.context.AuthenticationContext;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.auth.authentication.factory.AuthenticationFactory;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.AbortProcessException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AuthenticationPipeline
implements RequestPipeline {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final AuthConfig authConfig;
    private final AuthenticationEvaluator evaluator;

    public AuthenticationPipeline(AuthConfig authConfig) {
        this.authConfig = authConfig;
        this.evaluator = AuthenticationFactory.getEvaluator((AuthConfig)authConfig);
    }

    public void execute(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        if (!this.authConfig.isAuthenticationEnabled()) {
            return;
        }
        try {
            AuthenticationContext authenticationContext = this.newContext(ctx, request);
            this.evaluator.evaluate(authenticationContext);
        }
        catch (AuthenticationException ex) {
            throw new AbortProcessException(16, ex.getMessage());
        }
        catch (Throwable ex) {
            LOGGER.error("authenticate failed, request:{}", (Object)request, (Object)ex);
            throw ex;
        }
    }

    protected AuthenticationContext newContext(ChannelHandlerContext ctx, RemotingCommand request) {
        return AuthenticationFactory.newContext((AuthConfig)this.authConfig, (ChannelHandlerContext)ctx, (RemotingCommand)request);
    }
}

