/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLimitController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryLimitController.class);
    private final long memoryLimit;
    private final long triggerThreshold;
    private final Runnable trigger;
    private final AtomicLong currentUsage = new AtomicLong();
    private final ReentrantLock mutex = new ReentrantLock(false);
    private final Condition condition = this.mutex.newCondition();
    private final AtomicBoolean triggerRunning = new AtomicBoolean(false);

    public MemoryLimitController(long memoryLimitBytes) {
        this.memoryLimit = memoryLimitBytes;
        this.triggerThreshold = 0L;
        this.trigger = null;
    }

    public MemoryLimitController(long memoryLimitBytes, long triggerThreshold, Runnable trigger) {
        this.memoryLimit = memoryLimitBytes;
        this.triggerThreshold = triggerThreshold;
        this.trigger = trigger;
    }

    public void forceReserveMemory(long size) {
        MemoryLimitController.checkPositive(size);
        if (size == 0L) {
            return;
        }
        long newUsage = this.currentUsage.addAndGet(size);
        this.checkTrigger(newUsage - size, newUsage);
    }

    public boolean tryReserveMemory(long size) {
        long newUsage;
        long current;
        MemoryLimitController.checkPositive(size);
        if (size == 0L) {
            return true;
        }
        do {
            current = this.currentUsage.get();
            newUsage = current + size;
            if (current <= this.memoryLimit || this.memoryLimit <= 0L) continue;
            return false;
        } while (!this.currentUsage.compareAndSet(current, newUsage));
        this.checkTrigger(current, newUsage);
        return true;
    }

    private static void checkPositive(long memorySize) {
        if (memorySize < 0L) {
            String errorMsg = String.format("Try to reserve/release memory failed, the param memorySize is a negative value: %s", memorySize);
            log.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTrigger(long prevUsage, long newUsage) {
        if (newUsage >= this.triggerThreshold && prevUsage < this.triggerThreshold && this.trigger != null && this.triggerRunning.compareAndSet(false, true)) {
            try {
                this.trigger.run();
            }
            finally {
                this.triggerRunning.set(false);
            }
        }
    }

    public void reserveMemory(long size) throws InterruptedException {
        MemoryLimitController.checkPositive(size);
        if (size == 0L) {
            return;
        }
        if (!this.tryReserveMemory(size)) {
            this.mutex.lock();
            try {
                while (!this.tryReserveMemory(size)) {
                    this.condition.await();
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory(long size) {
        MemoryLimitController.checkPositive(size);
        if (size == 0L) {
            return;
        }
        long newUsage = this.currentUsage.addAndGet(-size);
        if (newUsage + size > this.memoryLimit && newUsage <= this.memoryLimit) {
            this.mutex.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public long currentUsage() {
        return this.currentUsage.get();
    }

    public double currentUsagePercent() {
        return 1.0 * (double)this.currentUsage.get() / (double)this.memoryLimit;
    }

    public boolean isMemoryLimited() {
        return this.memoryLimit > 0L;
    }
}

