/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.util;

import org.apache.commons.lang.StringUtils;

/**
 * Utilities for content rewriting.
 */
public class RewriterUtils
{

    /**
     * External URL resources which are not generated from the repository resources.
     */
    private static final String[] DEFAULT_NONREWRITABLE_URL_PREFIX = { "#", "javascript:", "mailto:", "data:", "webdav:", "ftp:", "callto:", "tel:", "sms:" };

    /**
     * Returns true if the given <code>uri</code> can be rewritten by this. Otherwise it returns false.
     * @param uri
     * @return
     */
    public static boolean isRewritableURI(String uri)
    {
        if (StringUtils.isBlank(uri))
        {
            return false;
        }

        for (String prefix : DEFAULT_NONREWRITABLE_URL_PREFIX)
        {
            if (uri.startsWith(prefix))
            {
                return false;
            }
        }

        return true;
    }

    private RewriterUtils() {
    }

}
