/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.hexviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.pdfbox.debugger.hexviewer.HexChangeListener;
import org.apache.pdfbox.debugger.hexviewer.HexChangedEvent;
import org.apache.pdfbox.debugger.hexviewer.HexModel;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangeListener;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangedEvent;
import org.apache.pdfbox.debugger.hexviewer.HexView;
import org.apache.pdfbox.debugger.hexviewer.SelectEvent;
import org.apache.pdfbox.debugger.hexviewer.SelectionChangeListener;

class HexPane
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
HexModelChangeListener {
    private final HexModel model;
    private int selectedIndex = -1;
    private static final byte EDIT = 2;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 0;
    private byte state = 0;
    private int selectedChar = 0;
    private final List<HexChangeListener> hexChangeListeners = new ArrayList<HexChangeListener>();
    private final List<SelectionChangeListener> selectionChangeListeners = new ArrayList<SelectionChangeListener>();

    HexPane(HexModel model) {
        this.model = model;
        model.addHexModelChangeListener(this);
        this.setPreferredSize(new Dimension(600, 20 * (model.totalLine() + 1)));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setAutoscrolls(true);
        this.setFont(HexView.FONT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(HexView.RENDERING_HINTS);
        Rectangle bound = this.getVisibleRect();
        g.clearRect(bound.x, bound.y, bound.width, bound.height);
        g.setColor(Color.WHITE);
        g.fillRect(bound.x, bound.y, bound.width, bound.height);
        int x = 20;
        int y = bound.y;
        if (y == 0 || y % 20 != 0) {
            y += 20 - y % 20;
        }
        int firstLine = y / 20;
        g.setColor(Color.BLACK);
        for (int i = firstLine; i <= firstLine + bound.height / 20 && i <= this.model.totalLine(); ++i) {
            byte[] bytes = this.model.getBytesForLine(i);
            int index = (i - 1) * 16;
            for (byte by : bytes) {
                String str = String.format("%02X", by);
                if (this.selectedIndex == index && this.state == 1) {
                    g.drawString(this.getSelectedString(str).getIterator(), x, y);
                } else if (this.selectedIndex == index && this.state == 2) {
                    this.paintInEdit(g, by, x, y);
                } else {
                    g.drawString(str, x, y);
                }
                x += 35;
                ++index;
            }
            x = 20;
            y += 20;
        }
    }

    private void paintInEdit(Graphics g, byte content, int x, int y) {
        g.setFont(HexView.BOLD_FONT);
        g.setColor(Color.white);
        char[] chars = this.getChars(content);
        if (this.selectedChar == 0) {
            g.setColor(HexView.SELECTED_COLOR);
            g.drawChars(chars, 0, 1, x, y);
            g.setColor(Color.black);
            g.drawChars(chars, 1, 1, x + g.getFontMetrics().charWidth(chars[0]), y);
        } else {
            g.setColor(Color.black);
            g.drawChars(chars, 0, 1, x, y);
            g.setColor(HexView.SELECTED_COLOR);
            g.drawChars(chars, 1, 1, x + g.getFontMetrics().charWidth(chars[0]), y);
        }
        this.setDefault(g);
    }

    private AttributedString getSelectedString(String str) {
        AttributedString string = new AttributedString(str);
        string.addAttribute(TextAttribute.FONT, HexView.BOLD_FONT);
        string.addAttribute(TextAttribute.FOREGROUND, HexView.SELECTED_COLOR);
        return string;
    }

    private void setDefault(Graphics g) {
        g.setColor(Color.black);
        g.setFont(this.getFont());
    }

    private int getIndexForPoint(Point point) {
        if (point.x <= 20 || point.x >= 580) {
            return -1;
        }
        int y = point.y;
        int lineNumber = (y + (20 - y % 20)) / 20;
        int x = point.x - 20;
        int elementNumber = x / 35;
        return (lineNumber - 1) * 16 + elementNumber;
    }

    private Point getPointForIndex(int index) {
        int x = 20 + HexModel.elementIndexInLine(index) * 35;
        int y = HexModel.lineNumber(index) * 20;
        return new Point(x, y);
    }

    private void putInSelected(int index) {
        this.state = 1;
        this.selectedChar = 0;
        Point point = this.getPointForIndex(index);
        if (index % 16 == 0) {
            this.scrollRectToVisible(new Rectangle(0, HexModel.lineNumber(index) * 20, 1, 1));
        } else if (!this.getVisibleRect().intersects(point.x, point.y, 35.0, 20.0)) {
            this.scrollRectToVisible(new Rectangle(point.x, point.y, 35, 20));
        }
        this.selectedIndex = index;
        this.repaint();
        this.requestFocusInWindow();
    }

    private void fireSelectionChanged(SelectEvent event) {
        this.selectionChangeListeners.forEach(listener -> listener.selectionChanged(event));
    }

    private void fireHexValueChanged(byte value, int index) {
        this.hexChangeListeners.forEach(listener -> listener.hexChanged(new HexChangedEvent(value, index)));
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public void addHexChangeListeners(HexChangeListener listener) {
        this.hexChangeListeners.add(listener);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c;
        if (this.selectedIndex != -1 && HexPane.isHexChar(c = keyEvent.getKeyChar())) {
            byte previousByte = this.model.getByte(this.selectedIndex);
            char[] chars = this.getChars(previousByte);
            chars[this.selectedChar] = c;
            byte editByte = this.getByte(chars);
            if (this.selectedChar == 0) {
                this.state = (byte)2;
                this.selectedChar = 1;
                this.fireHexValueChanged(editByte, this.selectedIndex);
            } else {
                this.fireHexValueChanged(editByte, this.selectedIndex);
                this.fireSelectionChanged(new SelectEvent(this.selectedIndex, "next"));
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.state == 1 || this.state == 2) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (this.state == 2 && this.selectedChar == 1) {
                        this.selectedChar = 0;
                        this.repaint();
                        break;
                    }
                    this.fireSelectionChanged(new SelectEvent(this.selectedIndex, "previous"));
                    break;
                }
                case 39: {
                    this.fireSelectionChanged(new SelectEvent(this.selectedIndex, "next"));
                    break;
                }
                case 38: {
                    this.fireSelectionChanged(new SelectEvent(this.selectedIndex, "up"));
                    break;
                }
                case 40: {
                    this.fireSelectionChanged(new SelectEvent(this.selectedIndex, "down"));
                    break;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int index = this.getIndexForPoint(mouseEvent.getPoint());
        if (index == -1) {
            this.fireSelectionChanged(new SelectEvent(-1, "none"));
            return;
        }
        this.fireSelectionChanged(new SelectEvent(index, "in"));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private char[] getChars(byte b) {
        return String.format("%02X", b & 0xFF).toCharArray();
    }

    private byte getByte(char[] chars) {
        return (byte)(Integer.parseInt(new String(chars), 16) & 0xFF);
    }

    public void setSelected(int index) {
        if (index != this.selectedIndex) {
            this.putInSelected(index);
        }
    }

    @Override
    public void hexModelChanged(HexModelChangedEvent event) {
        this.repaint();
    }
}

