/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.util.CSVUtil;
import org.apache.lucene.analysis.ko.util.UnknownDictionaryWriter;

class UnknownDictionaryBuilder {
    private static final String NGRAM_DICTIONARY_ENTRY = "NGRAM,1798,3559,3677,SY,*,*,*,*,*,*,*";
    private String encoding;

    UnknownDictionaryBuilder(String encoding) {
        this.encoding = encoding;
    }

    public UnknownDictionaryWriter build(Path dir) throws IOException {
        UnknownDictionaryWriter unkDictionary = this.readDictionaryFile(dir.resolve("unk.def"));
        this.readCharacterDefinition(dir.resolve("char.def"), unkDictionary);
        return unkDictionary;
    }

    private UnknownDictionaryWriter readDictionaryFile(Path path) throws IOException {
        return this.readDictionaryFile(path, this.encoding);
    }

    private UnknownDictionaryWriter readDictionaryFile(Path path, String encoding) throws IOException {
        UnknownDictionaryWriter dictionary = new UnknownDictionaryWriter(0x500000);
        ArrayList<String[]> lines = new ArrayList<String[]>();
        try (BufferedReader reader = Files.newBufferedReader(path, Charset.forName(encoding));
             LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            dictionary.put(CSVUtil.parse(NGRAM_DICTIONARY_ENTRY));
            while ((line = lineReader.readLine()) != null) {
                String[] parsed = CSVUtil.parse(line + ",*,*");
                lines.add(parsed);
            }
        }
        lines.sort(Comparator.comparingInt(entry -> CharacterDefinition.lookupCharacterClass(entry[0])));
        for (String[] entry2 : lines) {
            dictionary.put(entry2);
        }
        return dictionary;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCharacterDefinition(Path path, UnknownDictionaryWriter dictionary) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, Charset.forName(this.encoding));
             LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            block18: while ((line = lineReader.readLine()) != null) {
                String[] values;
                line = line.replaceAll("^\\s", "");
                line = line.replaceAll("\\s*#.*", "");
                if ((line = line.replaceAll("\\s+", " ")).length() == 0) continue;
                if (line.startsWith("0x")) {
                    values = line.split(" ", 2);
                    if (!values[0].contains("..")) {
                        int cp = Integer.decode(values[0]);
                        dictionary.putCharacterCategory(cp, values[1]);
                        continue;
                    }
                    String[] codePoints = values[0].split("\\.\\.");
                    int cpFrom = Integer.decode(codePoints[0]);
                    int cpTo = Integer.decode(codePoints[1]);
                    int i = cpFrom;
                    while (true) {
                        if (i > cpTo) continue block18;
                        dictionary.putCharacterCategory(i, values[1]);
                        ++i;
                    }
                }
                values = line.split(" ");
                String characterClassName = values[0];
                int invoke = Integer.parseInt(values[1]);
                int group = Integer.parseInt(values[2]);
                int length = Integer.parseInt(values[3]);
                dictionary.putInvokeDefinition(characterClassName, invoke, group, length);
            }
            return;
        }
    }
}

