/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.TreeMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;

public abstract class JaasCommandSupport
implements Action {
    public static final String JAAS_REALM = "JaasCommand.REALM";
    public static final String JAAS_ENTRY = "JaasCommand.ENTRY";
    public static final String JAAS_CMDS = "JaasCommand.COMMANDS";
    @Reference
    List<BackingEngineFactory> engineFactories;
    @Reference
    List<JaasRealm> realms;
    @Reference
    Session session;

    protected abstract Object doExecute(BackingEngine var1) throws Exception;

    public Object execute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get(JAAS_REALM);
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get(JAAS_ENTRY);
        Queue commandQueue = (Queue)this.session.get(JAAS_CMDS);
        if (realm != null && entry != null) {
            if (commandQueue != null) {
                commandQueue.add(this);
            }
        } else {
            System.err.println("No JAAS Realm / Module has been selected");
        }
        return null;
    }

    public BackingEngine getBackingEngine(AppConfigurationEntry entry) {
        if (this.engineFactories != null) {
            for (BackingEngineFactory factory : this.engineFactories) {
                String loginModuleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
                if (!factory.getModuleClass().equals(loginModuleClass)) continue;
                return factory.build(entry.getOptions());
            }
        }
        return null;
    }

    public List<JaasRealm> getRealms() {
        return this.getRealms(false);
    }

    public List<JaasRealm> getRealms(boolean hidden) {
        if (hidden) {
            return this.realms;
        }
        TreeMap<String, JaasRealm> map = new TreeMap<String, JaasRealm>();
        for (JaasRealm realm : this.realms) {
            if (map.containsKey(realm.getName()) && realm.getRank() <= ((JaasRealm)map.get(realm.getName())).getRank()) continue;
            map.put(realm.getName(), realm);
        }
        return new ArrayList<JaasRealm>(map.values());
    }

    public void setRealms(List<JaasRealm> realms) {
        this.realms = realms;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

