/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.impl.InventoryPrinterHandler;
import org.apache.felix.inventory.impl.InventoryPrinterManagerImpl;
import org.apache.felix.inventory.impl.helper.ConfigurationWriter;
import org.apache.felix.inventory.impl.helper.HtmlConfigurationWriter;
import org.apache.felix.inventory.impl.helper.JSONConfigurationWriter;
import org.apache.felix.inventory.impl.helper.PlainTextConfigurationWriter;
import org.apache.felix.inventory.impl.helper.ZipConfigurationWriter;

public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final InventoryPrinterManagerImpl inventoryPrinterManager;

    AbstractWebConsolePlugin(InventoryPrinterManagerImpl inventoryPrinterManager) {
        this.inventoryPrinterManager = inventoryPrinterManager;
    }

    protected abstract InventoryPrinterHandler getInventoryPrinterHandler();

    private void printConfigurationInventory(ConfigurationWriter pw, Format format, InventoryPrinterHandler handler) throws IOException {
        if (handler == null) {
            InventoryPrinterHandler[] adapters = this.inventoryPrinterManager.getHandlers(format);
            for (int i = 0; i < adapters.length; ++i) {
                pw.printInventory(format, adapters[i]);
            }
        } else if (format == null || handler.supports(format)) {
            pw.printInventory(format, handler);
        }
    }

    private final void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Thu, 01 Jan 1970 01:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
    }

    protected InventoryPrinterHandler getInventoryPrinterHandler(String label) {
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InventoryPrinterHandler handler;
        this.setNoCache(response);
        String pathInfo = request.getPathInfo();
        int lastSlash = pathInfo.lastIndexOf(47);
        if (lastSlash > 0) {
            int lastDot = pathInfo.lastIndexOf(46);
            String label = lastDot < lastSlash ? pathInfo.substring(lastSlash + 1) : pathInfo.substring(lastSlash + 1, lastDot);
            handler = this.getInventoryPrinterHandler(label);
        } else {
            handler = this.getInventoryPrinterHandler();
            if (handler == null) {
                response.sendError(404);
                return;
            }
        }
        if (request.getPathInfo().endsWith(".txt")) {
            response.setContentType("text/plain; charset=utf-8");
            PlainTextConfigurationWriter pw = new PlainTextConfigurationWriter(response.getWriter());
            this.printConfigurationInventory(pw, Format.TEXT, handler);
            pw.flush();
        } else if (request.getPathInfo().endsWith(".zip")) {
            String type = this.getServletContext().getMimeType(request.getPathInfo());
            if (type == null) {
                type = "application/x-zip";
            }
            response.setContentType(type);
            ZipConfigurationWriter pw = ZipConfigurationWriter.create((OutputStream)response.getOutputStream());
            this.printConfigurationInventory(pw, null, handler);
            pw.finish();
        } else {
            if (request.getPathInfo().endsWith(".nfo")) {
                if (handler == null) {
                    response.sendError(404);
                    return;
                }
                response.setContentType("text/html; charset=utf-8");
                HtmlConfigurationWriter pw = new HtmlConfigurationWriter(response.getWriter());
                pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
                pw.println("  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
                pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
                pw.println("<head><title>dummy</title></head><body><div>");
                if (handler.supports(Format.HTML)) {
                    handler.print(pw, Format.HTML, false);
                } else if (handler.supports(Format.TEXT)) {
                    pw.enableFilter(true);
                    handler.print(pw, Format.TEXT, false);
                    pw.enableFilter(false);
                } else {
                    pw.enableFilter(true);
                    handler.print(pw, Format.JSON, false);
                    pw.enableFilter(false);
                }
                pw.println("</div></body></html>");
                return;
            }
            if (request.getPathInfo().endsWith(".json")) {
                Format format;
                if (handler == null) {
                    response.sendError(404);
                    return;
                }
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                JSONConfigurationWriter jcw = new JSONConfigurationWriter(response.getWriter());
                if (handler.supports(Format.JSON)) {
                    format = Format.JSON;
                } else {
                    format = Format.TEXT;
                    jcw.startJSONWrapper();
                }
                this.printConfigurationInventory(jcw, format, handler);
                jcw.endJSONWrapper();
                jcw.flush();
            } else {
                Format format;
                boolean filter;
                if (handler == null) {
                    response.sendError(404);
                    return;
                }
                HtmlConfigurationWriter pw = new HtmlConfigurationWriter(response.getWriter());
                pw.println("<script type=\"text/javascript\">");
                pw.println("// <![CDATA[");
                pw.println("function pad(value) { if ( value < 10 ) { return '0' + value;} return '' + value;}");
                pw.println("function downloadDump(ext, full) {");
                pw.println("  if (full) {");
                pw.println("    var now = new Date();");
                pw.println("    var name = \"configuration-status-\" + now.getUTCFullYear() + pad(now.getUTCMonth() + 1) + pad(now.getUTCDate()) + \"-\" + pad(now.getUTCHours()) + pad(now.getUTCMinutes()) + pad(now.getUTCSeconds()) + \".\";");
                pw.println("    location.href = location.href + \"/\" + name + ext;");
                pw.println("  } else {");
                pw.println("    location.href = location.href + '.' + ext;");
                pw.println("  }");
                pw.println("}");
                pw.println("$(document).ready(function() {");
                pw.println("    $('.downloadTxt').click(function() { downloadDump('txt', false)});");
                pw.println("    $('.downloadJson').click(function() { downloadDump('json', false)});");
                pw.println("    $('.downloadZip').click(function() { downloadDump('zip', false)});");
                pw.println("    $('.downloadFullZip').click(function() { downloadDump('zip', true)});");
                pw.println("    $('.downloadFullTxt').click(function() { downloadDump('txt', true)});");
                pw.println("});");
                pw.println("// ]]>");
                pw.println("</script>");
                pw.println("<br/><p class=\"statline\">");
                pw.print("Date: ");
                pw.println(DateFormat.getDateTimeInstance(1, 1, Locale.US).format(new Date()));
                pw.print("<button type=\"button\" class=\"downloadFullZip\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download Full Zip</button>");
                pw.print("<button type=\"button\" class=\"downloadFullTxt\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download Full Text</button>");
                if (handler.supports(Format.JSON)) {
                    pw.print("<button type=\"button\" class=\"downloadJson\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download As JSON</button>");
                }
                pw.print("<button type=\"button\" class=\"downloadZip\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download As Zip</button>");
                if (handler.supports(Format.TEXT)) {
                    pw.print("<button type=\"button\" class=\"downloadTxt\" style=\"float: right; margin-right: 30px; margin-top: 5px;\">Download As Text</button>");
                }
                pw.println("<br/>&nbsp;</p>");
                pw.print("<div>");
                if (handler.supports(Format.HTML)) {
                    filter = false;
                    format = Format.HTML;
                } else if (handler.supports(Format.TEXT)) {
                    filter = true;
                    format = Format.TEXT;
                } else if (handler.supports(Format.JSON)) {
                    filter = true;
                    format = Format.JSON;
                } else {
                    filter = true;
                    format = Format.TEXT;
                }
                pw.enableFilter(filter);
                handler.print(pw, format, false);
                pw.enableFilter(false);
                pw.print("</div>");
            }
        }
    }
}

