/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import jakarta.mail.Flags;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAAttachment;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumns;

@Entity(name="MailboxMessage")
@Table(name="JAMES_MAIL")
public class JPAMailboxMessageWithAttachmentStorage
extends AbstractJPAMailboxMessage
implements PersistenceCapable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    @Lob
    private byte[] body;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    @Lob
    private byte[] header;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="attachmentId")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAAttachment> attachments;
    private static int pcInheritedFieldCount = AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public JPAMailboxMessageWithAttachmentStorage() {
    }

    public JPAMailboxMessageWithAttachmentStorage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, Content content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        try {
            int headerEnd = bodyStartOctet;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            InputStream stream = content.getInputStream();
            this.header = IOUtils.toByteArray((InputStream)new BoundedInputStream(stream, (long)headerEnd));
            this.body = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
        this.attachments = new ArrayList<JPAAttachment>();
    }

    public JPAMailboxMessageWithAttachmentStorage(JPAMailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.body = IOUtils.toByteArray((InputStream)message.getBodyContent());
            this.header = IOUtils.toByteArray((InputStream)message.getHeaderContent());
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
        this.attachments = new ArrayList<JPAAttachment>();
    }

    public InputStream getBodyContent() throws IOException {
        if (JPAMailboxMessageWithAttachmentStorage.pcGetbody(this) == null) {
            return new ByteArrayInputStream(EMPTY_ARRAY);
        }
        return new ByteArrayInputStream(JPAMailboxMessageWithAttachmentStorage.pcGetbody(this));
    }

    public InputStream getHeaderContent() throws IOException {
        if (JPAMailboxMessageWithAttachmentStorage.pcGetheader(this) == null) {
            return new ByteArrayInputStream(EMPTY_ARRAY);
        }
        return new ByteArrayInputStream(JPAMailboxMessageWithAttachmentStorage.pcGetheader(this));
    }

    public MailboxMessage copy(Mailbox mailbox) throws MailboxException {
        return new JPAMailboxMessage(JPAMailbox.from(mailbox), this.getUid(), this.getModSeq(), this);
    }

    public void setAttachments(List<JPAAttachment> attachments) {
        JPAMailboxMessageWithAttachmentStorage.pcSetattachments(this, attachments);
    }

    @Override
    public List<MessageAttachmentMetadata> getAttachments() {
        return JPAMailboxMessageWithAttachmentStorage.pcGetattachments(this).stream().map(JPAAttachment::toMessageAttachmentMetadata).collect(Collectors.toList());
    }

    static {
        pcPCSuperclass = AbstractJPAMailboxMessage.class;
        pcFieldNames = new String[]{"attachments", "body", "header"};
        pcFieldTypes = new Class[]{List.class, byte[].class, byte[].class};
        pcFieldFlags = new byte[]{10, 21, 21};
        PCRegistry.register(JPAMailboxMessageWithAttachmentStorage.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailboxMessage", (PersistenceCapable)new JPAMailboxMessageWithAttachmentStorage());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.attachments = null;
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage = new JPAMailboxMessageWithAttachmentStorage();
        if (bl) {
            jPAMailboxMessageWithAttachmentStorage.pcClearFields();
        }
        jPAMailboxMessageWithAttachmentStorage.pcStateManager = stateManager;
        jPAMailboxMessageWithAttachmentStorage.pcCopyKeyFieldsFromObjectId(object);
        return jPAMailboxMessageWithAttachmentStorage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage = new JPAMailboxMessageWithAttachmentStorage();
        if (bl) {
            jPAMailboxMessageWithAttachmentStorage.pcClearFields();
        }
        jPAMailboxMessageWithAttachmentStorage.pcStateManager = stateManager;
        return jPAMailboxMessageWithAttachmentStorage;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.attachments = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.body = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.header = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.attachments);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAMailboxMessageWithAttachmentStorage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.attachments = jPAMailboxMessageWithAttachmentStorage.attachments;
                return;
            }
            case 1: {
                this.body = jPAMailboxMessageWithAttachmentStorage.body;
                return;
            }
            case 2: {
                this.header = jPAMailboxMessageWithAttachmentStorage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage = (JPAMailboxMessageWithAttachmentStorage)object;
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAMailboxMessageWithAttachmentStorage, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAMailboxMessageWithAttachmentStorage.class;
    }

    private static final List pcGetattachments(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            return jPAMailboxMessageWithAttachmentStorage.attachments;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.accessingField(n);
        return jPAMailboxMessageWithAttachmentStorage.attachments;
    }

    private static final void pcSetattachments(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage, List list) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            jPAMailboxMessageWithAttachmentStorage.attachments = list;
            return;
        }
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.settingObjectField((PersistenceCapable)jPAMailboxMessageWithAttachmentStorage, pcInheritedFieldCount + 0, jPAMailboxMessageWithAttachmentStorage.attachments, (Object)list, 0);
    }

    private static final byte[] pcGetbody(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            return jPAMailboxMessageWithAttachmentStorage.body;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.accessingField(n);
        return jPAMailboxMessageWithAttachmentStorage.body;
    }

    private static final void pcSetbody(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage, byte[] byArray) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            jPAMailboxMessageWithAttachmentStorage.body = byArray;
            return;
        }
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.settingObjectField((PersistenceCapable)jPAMailboxMessageWithAttachmentStorage, pcInheritedFieldCount + 1, (Object)jPAMailboxMessageWithAttachmentStorage.body, (Object)byArray, 0);
    }

    private static final byte[] pcGetheader(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            return jPAMailboxMessageWithAttachmentStorage.header;
        }
        int n = pcInheritedFieldCount + 2;
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.accessingField(n);
        return jPAMailboxMessageWithAttachmentStorage.header;
    }

    private static final void pcSetheader(JPAMailboxMessageWithAttachmentStorage jPAMailboxMessageWithAttachmentStorage, byte[] byArray) {
        if (jPAMailboxMessageWithAttachmentStorage.pcStateManager == null) {
            jPAMailboxMessageWithAttachmentStorage.header = byArray;
            return;
        }
        jPAMailboxMessageWithAttachmentStorage.pcStateManager.settingObjectField((PersistenceCapable)jPAMailboxMessageWithAttachmentStorage, pcInheritedFieldCount + 2, (Object)jPAMailboxMessageWithAttachmentStorage.header, (Object)byArray, 0);
    }
}

