/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.MoreObjects;
import java.util.EnumSet;

public class StatusDataItems {
    public static final String SIMPLE_NAME = StatusDataItems.class.getSimpleName();
    private final EnumSet<StatusItem> statusItems;

    public StatusDataItems(EnumSet<StatusItem> statusItems) {
        this.statusItems = statusItems;
    }

    public boolean isAppendLimit() {
        return this.statusItems.contains((Object)StatusItem.APPENDLIMIT);
    }

    public boolean isMessages() {
        return this.statusItems.contains((Object)StatusItem.MESSAGES);
    }

    public boolean isRecent() {
        return this.statusItems.contains((Object)StatusItem.RECENT);
    }

    public boolean isUidNext() {
        return this.statusItems.contains((Object)StatusItem.UID_NEXT);
    }

    public boolean isUidValidity() {
        return this.statusItems.contains((Object)StatusItem.UID_VALIDITY);
    }

    public boolean isUnseen() {
        return this.statusItems.contains((Object)StatusItem.UNSEEN);
    }

    public boolean isMailboxId() {
        return this.statusItems.contains((Object)StatusItem.MAILBOXID);
    }

    public boolean isHighestModSeq() {
        return this.statusItems.contains((Object)StatusItem.HIGHEST_MODSEQ);
    }

    public boolean isSize() {
        return this.statusItems.contains((Object)StatusItem.SIZE);
    }

    public boolean isDeleted() {
        return this.statusItems.contains((Object)StatusItem.DELETED);
    }

    public boolean isDeletedStorage() {
        return this.statusItems.contains((Object)StatusItem.DELETED_STORAGE);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)SIMPLE_NAME).add("statusItems", this.statusItems).toString();
    }

    public static enum StatusItem {
        APPENDLIMIT,
        MESSAGES,
        MAILBOXID,
        RECENT,
        UID_NEXT,
        UID_VALIDITY,
        UNSEEN,
        HIGHEST_MODSEQ,
        SIZE,
        DELETED,
        DELETED_STORAGE;

    }
}

