/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchChangeSelectionCriteria;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IgnoreAttributesChangeSelectionCriteria
extends ChangelogBatchChangeSelectionCriteria {
    static final byte TYPE_SELECTION_CRITERIA_IGNORE_ATTRIBUTES = -93;
    private final boolean ignoreOperationalAttributes;
    @NotNull
    private final List<String> attributeNames;

    public IgnoreAttributesChangeSelectionCriteria(boolean ignoreOperationalAttributes, String ... attributeNames) {
        this(ignoreOperationalAttributes, StaticUtils.toList(attributeNames));
    }

    public IgnoreAttributesChangeSelectionCriteria(boolean ignoreOperationalAttributes, @Nullable Collection<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            Validator.ensureTrue(ignoreOperationalAttributes);
            this.attributeNames = Collections.emptyList();
        } else {
            this.attributeNames = Collections.unmodifiableList(new ArrayList<String>(attributeNames));
        }
        this.ignoreOperationalAttributes = ignoreOperationalAttributes;
    }

    @NotNull
    static IgnoreAttributesChangeSelectionCriteria decodeInnerElement(@NotNull ASN1Element innerElement) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(innerElement).elements();
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
            ArrayList<String> attrNames = new ArrayList<String>(attrElements.length);
            for (ASN1Element e : attrElements) {
                attrNames.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            return new IgnoreAttributesChangeSelectionCriteria(ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue(), attrNames);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_IGNORE_ATTRS_CHANGE_SELECTION_CRITERIA_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public boolean ignoreOperationalAttributes() {
        return this.ignoreOperationalAttributes;
    }

    @NotNull
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    @NotNull
    public ASN1Element encodeInnerElement() {
        ArrayList<ASN1OctetString> attrNameElements = new ArrayList<ASN1OctetString>(this.attributeNames.size());
        for (String s : this.attributeNames) {
            attrNameElements.add(new ASN1OctetString(s));
        }
        return new ASN1Sequence(-93, new ASN1Sequence(attrNameElements), new ASN1Boolean(this.ignoreOperationalAttributes));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IgnoreAttributesChangeSelectionCriteria(attributeNames={");
        Iterator<String> iterator = this.attributeNames.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("}, ignoreOperationalAttributes=");
        buffer.append(this.ignoreOperationalAttributes);
        buffer.append(')');
    }
}

