/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FailoverServerSet
extends ServerSet {
    @NotNull
    private final AtomicBoolean reOrderOnFailover;
    @Nullable
    private volatile Long maxFailoverConnectionAge;
    @NotNull
    private final ServerSet[] serverSets;

    public FailoverServerSet(@NotNull String[] addresses, @NotNull int[] ports) {
        this(addresses, ports, null, null);
    }

    public FailoverServerSet(@NotNull String[] addresses, @NotNull int[] ports, @Nullable LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public FailoverServerSet(@NotNull String[] addresses, @NotNull int[] ports, @Nullable SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public FailoverServerSet(@NotNull String[] addresses, @NotNull int[] ports, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, socketFactory, connectionOptions, null, null);
    }

    public FailoverServerSet(@NotNull String[] addresses, @NotNull int[] ports, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions, @Nullable BindRequest bindRequest, @Nullable PostConnectProcessor postConnectProcessor) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "FailoverServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "FailoverServerSet addresses and ports arrays must be the same size.");
        this.reOrderOnFailover = new AtomicBoolean(false);
        this.maxFailoverConnectionAge = null;
        SocketFactory sf = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        LDAPConnectionOptions co = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.serverSets = new ServerSet[addresses.length];
        for (int i = 0; i < this.serverSets.length; ++i) {
            this.serverSets[i] = new SingleServerSet(addresses[i], ports[i], sf, co, bindRequest, postConnectProcessor);
        }
    }

    public FailoverServerSet(ServerSet ... serverSets) {
        this(StaticUtils.toList(serverSets));
    }

    public FailoverServerSet(@NotNull List<ServerSet> serverSets) {
        Validator.ensureNotNull(serverSets);
        Validator.ensureFalse(serverSets.isEmpty(), "FailoverServerSet.serverSets must not be empty.");
        this.serverSets = new ServerSet[serverSets.size()];
        serverSets.toArray(this.serverSets);
        boolean anySupportsAuthentication = false;
        boolean allSupportAuthentication = true;
        boolean anySupportsPostConnectProcessing = false;
        boolean allSupportPostConnectProcessing = true;
        for (ServerSet serverSet : this.serverSets) {
            if (serverSet.includesAuthentication()) {
                anySupportsAuthentication = true;
            } else {
                allSupportAuthentication = false;
            }
            if (serverSet.includesPostConnectProcessing()) {
                anySupportsPostConnectProcessing = true;
                continue;
            }
            allSupportPostConnectProcessing = false;
        }
        if (anySupportsAuthentication) {
            Validator.ensureTrue(allSupportAuthentication, "When creating a FailoverServerSet from a collection of server sets, either all of those sets must include authentication, or none of those sets may include authentication.");
        }
        if (anySupportsPostConnectProcessing) {
            Validator.ensureTrue(allSupportPostConnectProcessing, "When creating a FailoverServerSet from a collection of server sets, either all of those sets must include post-connect processing, or none of those sets may include post-connect processing.");
        }
        this.reOrderOnFailover = new AtomicBoolean(false);
        this.maxFailoverConnectionAge = null;
    }

    @NotNull
    public ServerSet[] getServerSets() {
        return this.serverSets;
    }

    public boolean reOrderOnFailover() {
        return this.reOrderOnFailover.get();
    }

    public void setReOrderOnFailover(boolean reOrderOnFailover) {
        this.reOrderOnFailover.set(reOrderOnFailover);
    }

    @Nullable
    public Long getMaxFailoverConnectionAgeMillis() {
        return this.maxFailoverConnectionAge;
    }

    public void setMaxFailoverConnectionAgeMillis(@Nullable Long maxFailoverConnectionAge) {
        this.maxFailoverConnectionAge = maxFailoverConnectionAge == null ? null : (maxFailoverConnectionAge > 0L ? maxFailoverConnectionAge : Long.valueOf(0L));
    }

    @Override
    public boolean includesAuthentication() {
        return this.serverSets[0].includesAuthentication();
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.serverSets[0].includesPostConnectProcessing();
    }

    @Override
    @NotNull
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    @NotNull
    public LDAPConnection getConnection(@Nullable LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        if (this.reOrderOnFailover.get() && this.serverSets.length > 1) {
            FailoverServerSet failoverServerSet = this;
            synchronized (failoverServerSet) {
                try {
                    return this.serverSets[0].getConnection(healthCheck);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    int successfulPos = -1;
                    LDAPConnection conn = null;
                    LDAPException lastException = null;
                    for (int i = 1; i < this.serverSets.length; ++i) {
                        try {
                            conn = this.serverSets[i].getConnection(healthCheck);
                            successfulPos = i;
                            break;
                        }
                        catch (LDAPException le2) {
                            Debug.debugException(le2);
                            lastException = le2;
                            continue;
                        }
                    }
                    if (successfulPos > 0) {
                        int i;
                        int pos = 0;
                        ServerSet[] setCopy = new ServerSet[this.serverSets.length];
                        for (i = successfulPos; i < this.serverSets.length; ++i) {
                            setCopy[pos++] = this.serverSets[i];
                        }
                        for (i = 0; i < successfulPos; ++i) {
                            setCopy[pos++] = this.serverSets[i];
                        }
                        System.arraycopy(setCopy, 0, this.serverSets, 0, setCopy.length);
                        if (this.maxFailoverConnectionAge != null) {
                            conn.setAttachment(LDAPConnectionPool.ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxFailoverConnectionAge);
                        }
                        return conn;
                    }
                    throw lastException;
                }
            }
        }
        LDAPException lastException = null;
        boolean first = true;
        for (ServerSet s : this.serverSets) {
            try {
                LDAPConnection conn = s.getConnection(healthCheck);
                if (!first && this.maxFailoverConnectionAge != null) {
                    conn.setAttachment(LDAPConnectionPool.ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxFailoverConnectionAge);
                }
                return conn;
            }
            catch (LDAPException le) {
                first = false;
                Debug.debugException(le);
                lastException = le;
            }
        }
        throw lastException;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("FailoverServerSet(serverSets={");
        for (int i = 0; i < this.serverSets.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.serverSets[i].toString(buffer);
        }
        buffer.append("})");
    }
}

