/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReIndexingContext;
import org.apache.mailbox.tools.indexer.ReIndexingContextInformation;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.UserReindexingTaskDTO;
import reactor.core.publisher.Mono;

public class UserReindexingTask
implements Task {
    public static final TaskType USER_RE_INDEXING = TaskType.of((String)"user-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final Username username;
    private final ReIndexingContext reIndexingContext;
    private final ReIndexer.RunningOptions runningOptions;

    @Inject
    public UserReindexingTask(ReIndexerPerformer reIndexerPerformer, Username username, ReIndexer.RunningOptions runningOptions) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.username = username;
        this.reIndexingContext = new ReIndexingContext();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexUserMailboxes(this.username, this.reIndexingContext, this.runningOptions).onErrorResume(e -> Mono.just((Object)Task.Result.PARTIAL)).block();
    }

    public Username getUsername() {
        return this.username;
    }

    public TaskType type() {
        return USER_RE_INDEXING;
    }

    public ReIndexer.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.username, this.reIndexingContext.successfullyReprocessedMailCount(), this.reIndexingContext.failedReprocessingMailCount(), this.reIndexingContext.failures(), Clock.systemUTC().instant(), this.runningOptions));
    }

    public static class AdditionalInformation
    extends ReIndexingContextInformation {
        private final Username username;

        @VisibleForTesting
        public AdditionalInformation(Username username, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp, ReIndexer.RunningOptions runningOptions) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp, runningOptions);
            this.username = username;
        }

        public String getUsername() {
            return this.username.asString();
        }
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer) {
            this.reIndexerPerformer = reIndexerPerformer;
        }

        public UserReindexingTask create(UserReindexingTaskDTO dto) {
            Username username = Username.of((String)dto.getUsername());
            return new UserReindexingTask(this.reIndexerPerformer, username, dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT));
        }
    }
}

