/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.AuthenticationCleartextPassword;
import io.r2dbc.postgresql.message.backend.AuthenticationGSS;
import io.r2dbc.postgresql.message.backend.AuthenticationGSSContinue;
import io.r2dbc.postgresql.message.backend.AuthenticationKerberosV5;
import io.r2dbc.postgresql.message.backend.AuthenticationMD5Password;
import io.r2dbc.postgresql.message.backend.AuthenticationOk;
import io.r2dbc.postgresql.message.backend.AuthenticationSASL;
import io.r2dbc.postgresql.message.backend.AuthenticationSASLContinue;
import io.r2dbc.postgresql.message.backend.AuthenticationSASLFinal;
import io.r2dbc.postgresql.message.backend.AuthenticationSCMCredential;
import io.r2dbc.postgresql.message.backend.AuthenticationSSPI;
import io.r2dbc.postgresql.message.backend.BackendKeyData;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BindComplete;
import io.r2dbc.postgresql.message.backend.CloseComplete;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.CopyBothResponse;
import io.r2dbc.postgresql.message.backend.CopyData;
import io.r2dbc.postgresql.message.backend.CopyDone;
import io.r2dbc.postgresql.message.backend.CopyInResponse;
import io.r2dbc.postgresql.message.backend.CopyOutResponse;
import io.r2dbc.postgresql.message.backend.DataRow;
import io.r2dbc.postgresql.message.backend.EmptyQueryResponse;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.backend.FunctionCallResponse;
import io.r2dbc.postgresql.message.backend.NoData;
import io.r2dbc.postgresql.message.backend.NoticeResponse;
import io.r2dbc.postgresql.message.backend.NotificationResponse;
import io.r2dbc.postgresql.message.backend.ParameterDescription;
import io.r2dbc.postgresql.message.backend.ParameterStatus;
import io.r2dbc.postgresql.message.backend.ParseComplete;
import io.r2dbc.postgresql.message.backend.PortalSuspended;
import io.r2dbc.postgresql.message.backend.ReadyForQuery;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;

public final class BackendMessageDecoder {
    public static BackendMessage decode(ByteBuf envelope) {
        Assert.requireNonNull(envelope, "in must not be null");
        MessageType messageType = MessageType.valueOf(envelope.readByte());
        envelope.skipBytes(4);
        return BackendMessageDecoder.decodeBody(envelope, messageType);
    }

    private static BackendMessage decodeBody(ByteBuf body, MessageType messageType) {
        switch (messageType) {
            case AUTHENTICATION: {
                return BackendMessageDecoder.decodeAuthentication(body);
            }
            case BACKEND_KEY_DATA: {
                return BackendKeyData.decode(body);
            }
            case BIND_COMPLETE: {
                return BindComplete.INSTANCE;
            }
            case CLOSE_COMPLETE: {
                return CloseComplete.INSTANCE;
            }
            case COMMAND_COMPLETE: {
                return CommandComplete.decode(body);
            }
            case COPY_DATA: {
                return CopyData.decode(body);
            }
            case COPY_DONE: {
                return CopyDone.INSTANCE;
            }
            case COPY_BOTH_RESPONSE: {
                return CopyBothResponse.decode(body);
            }
            case COPY_IN_RESPONSE: {
                return CopyInResponse.decode(body);
            }
            case COPY_OUT_RESPONSE: {
                return CopyOutResponse.decode(body);
            }
            case DATA_ROW: {
                return DataRow.decode(body);
            }
            case EMPTY_QUERY_RESPONSE: {
                return EmptyQueryResponse.INSTANCE;
            }
            case ERROR_RESPONSE: {
                return ErrorResponse.decode(body);
            }
            case FUNCTION_CALL_RESPONSE: {
                return FunctionCallResponse.decode(body);
            }
            case NO_DATA: {
                return NoData.INSTANCE;
            }
            case NOTICE_RESPONSE: {
                return NoticeResponse.decode(body);
            }
            case NOTIFICATION_RESPONSE: {
                return NotificationResponse.decode(body);
            }
            case PARAMETER_DESCRIPTION: {
                return ParameterDescription.decode(body);
            }
            case PARAMETER_STATUS: {
                return ParameterStatus.decode(body);
            }
            case PARSE_COMPLETE: {
                return ParseComplete.INSTANCE;
            }
            case PORTAL_SUSPENDED: {
                return PortalSuspended.INSTANCE;
            }
            case READY_FOR_QUERY: {
                return ReadyForQuery.decode(body);
            }
            case ROW_DESCRIPTION: {
                return RowDescription.decode(body);
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a supported message type", new Object[]{messageType}));
    }

    private static BackendMessage decodeAuthentication(ByteBuf in) {
        AuthenticationType authenticationType = AuthenticationType.valueOf(in.readInt());
        switch (authenticationType) {
            case OK: {
                return AuthenticationOk.INSTANCE;
            }
            case KERBEROS_V5: {
                return AuthenticationKerberosV5.INSTANCE;
            }
            case CLEARTEXT_PASSWORD: {
                return AuthenticationCleartextPassword.INSTANCE;
            }
            case GSS: {
                return AuthenticationGSS.INSTANCE;
            }
            case GSS_CONTINUE: {
                return AuthenticationGSSContinue.decode(in);
            }
            case MD5_PASSWORD: {
                return AuthenticationMD5Password.decode(in);
            }
            case SCMC_CREDENTIAL: {
                return AuthenticationSCMCredential.INSTANCE;
            }
            case SASL: {
                return AuthenticationSASL.decode(in);
            }
            case SASL_CONTINUE: {
                return AuthenticationSASLContinue.decode(in);
            }
            case SASL_FINAL: {
                return AuthenticationSASLFinal.decode(in);
            }
            case SSPI: {
                return AuthenticationSSPI.INSTANCE;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a supported authentication type", new Object[]{authenticationType}));
    }

    private static enum MessageType {
        AUTHENTICATION('R'),
        BACKEND_KEY_DATA('K'),
        BIND_COMPLETE('2'),
        CLOSE_COMPLETE('3'),
        COMMAND_COMPLETE('C'),
        COPY_BOTH_RESPONSE('W'),
        COPY_DATA('d'),
        COPY_DONE('c'),
        COPY_IN_RESPONSE('G'),
        COPY_OUT_RESPONSE('H'),
        DATA_ROW('D'),
        EMPTY_QUERY_RESPONSE('I'),
        ERROR_RESPONSE('E'),
        FUNCTION_CALL_RESPONSE('V'),
        NO_DATA('n'),
        NOTICE_RESPONSE('N'),
        NOTIFICATION_RESPONSE('A'),
        PARAMETER_DESCRIPTION('t'),
        PARAMETER_STATUS('S'),
        PARSE_COMPLETE('1'),
        PORTAL_SUSPENDED('s'),
        READY_FOR_QUERY('Z'),
        ROW_DESCRIPTION('T');

        private static final MessageType[] CACHE;
        private final char discriminator;

        private MessageType(char discriminator) {
            this.discriminator = discriminator;
        }

        static MessageType valueOf(byte b) {
            MessageType messageType = CACHE[Math.abs(-128) + b];
            if (messageType == null) {
                throw new IllegalArgumentException(String.format("%c is not a valid message type", b));
            }
            return messageType;
        }

        static {
            CACHE = new MessageType[Math.abs(-128) + 127];
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MessageType messageType;
                MessageType.CACHE[Math.abs((int)-128) + (byte)messageType.discriminator] = messageType = messageTypeArray[i];
            }
        }
    }

    private static enum AuthenticationType {
        OK(0),
        KERBEROS_V5(2),
        CLEARTEXT_PASSWORD(3),
        GSS(7),
        GSS_CONTINUE(8),
        MD5_PASSWORD(5),
        SCMC_CREDENTIAL(6),
        SASL(10),
        SASL_CONTINUE(11),
        SASL_FINAL(12),
        SSPI(9);

        private final int discriminator;

        private AuthenticationType(int discriminator) {
            this.discriminator = discriminator;
        }

        static AuthenticationType valueOf(int i) {
            for (AuthenticationType authType : AuthenticationType.values()) {
                if (authType.discriminator != i) continue;
                return authType;
            }
            throw new IllegalArgumentException(String.format("%d is not a valid authentication type", i));
        }
    }
}

