/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mdn.fields.Field;

public class ExtensionField
implements Field {
    private final String fieldName;
    private final String rawValue;

    public static Builder builder() {
        return new Builder();
    }

    private ExtensionField(String fieldName, String rawValue) {
        this.fieldName = fieldName;
        this.rawValue = rawValue;
    }

    @Override
    public String formattedValue() {
        return this.fieldName + ": " + this.rawValue;
    }

    public final boolean equals(Object o) {
        if (o instanceof ExtensionField) {
            ExtensionField that = (ExtensionField)o;
            return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.rawValue, that.rawValue);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.fieldName, this.rawValue);
    }

    public String toString() {
        return this.formattedValue();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public static class Builder {
        private String fieldName;
        private String rawValue;

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public ExtensionField build() {
            Preconditions.checkNotNull(this.fieldName);
            Preconditions.checkNotNull(this.rawValue);
            Preconditions.checkState(!this.fieldName.contains("\n"), "Field name can not be multiline");
            return new ExtensionField(this.fieldName, this.rawValue);
        }
    }
}

