/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieveserver.netty.ManageSieveChannelUpstreamHandler;
import org.apache.james.managesieveserver.netty.ManageSieveServerMBean;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.AllButStartTlsLineChannelHandlerFactory;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.apache.james.protocols.netty.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSieveServer
extends AbstractConfigurableAsyncServer
implements ManageSieveServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveServer.class);
    static final String SSL_HANDLER = "sslHandler";
    static final String FRAMER = "framer";
    static final String CORE_HANDLER = "coreHandler";
    static final String CHUNK_WRITE_HANDLER = "chunkWriteHandler";
    private final int maxLineLength;
    private final ManageSieveProcessor manageSieveProcessor;
    private Optional<ConnectionLimitUpstreamHandler> connectionLimitUpstreamHandler = Optional.empty();
    private Optional<ConnectionPerIpLimitUpstreamHandler> connectionPerIpLimitUpstreamHandler = Optional.empty();

    public ManageSieveServer(int maxLineLength, ManageSieveProcessor manageSieveProcessor) {
        this.maxLineLength = maxLineLength;
        this.manageSieveProcessor = manageSieveProcessor;
    }

    protected int getDefaultPort() {
        return 4190;
    }

    protected void doConfigure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        super.doConfigure(config);
        this.connectionLimitUpstreamHandler = ConnectionLimitUpstreamHandler.forCount((int)this.connectionLimit);
        this.connectionPerIpLimitUpstreamHandler = ConnectionPerIpLimitUpstreamHandler.forCount((int)this.connPerIP);
    }

    protected String getDefaultJMXName() {
        return "managesieveserver";
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        return new ManageSieveChannelUpstreamHandler(this.manageSieveProcessor, this.getEncryption(), this.maxLineLength);
    }

    protected AbstractChannelPipelineFactory createPipelineFactory() {
        return new AbstractChannelPipelineFactory(this.createFrameHandlerFactory(), this.getExecutorGroup()){

            protected ChannelInboundHandlerAdapter createHandler() {
                return ManageSieveServer.this.createCoreHandler();
            }

            public void initChannel(Channel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                Encryption secure = ManageSieveServer.this.getEncryption();
                if (secure != null && !secure.isStartTLS()) {
                    pipeline.addFirst(ManageSieveServer.SSL_HANDLER, (ChannelHandler)secure.sslHandler());
                }
                ManageSieveServer.this.connectionLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionLimitHandler", (ChannelHandler)handler));
                ManageSieveServer.this.connectionPerIpLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)handler));
                pipeline.addLast(ManageSieveServer.this.getExecutorGroup(), ManageSieveServer.FRAMER, ManageSieveServer.this.getFrameHandlerFactory().create(pipeline));
                pipeline.addLast(ManageSieveServer.this.getExecutorGroup(), ManageSieveServer.CHUNK_WRITE_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(ManageSieveServer.this.getExecutorGroup(), "stringDecoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
                pipeline.addLast(ManageSieveServer.this.getExecutorGroup(), ManageSieveServer.CORE_HANDLER, (ChannelHandler)this.createHandler());
                pipeline.addLast(ManageSieveServer.this.getExecutorGroup(), "stringEncoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
            }
        };
    }

    public String getServiceType() {
        return "Manage Sieve Service";
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new AllButStartTlsLineChannelHandlerFactory("starttls", 8192);
    }
}

