/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class DeleCmdHandler
extends AbstractPOP3CommandHandler {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"DELE");
    private static final Response DELETED = new POP3Response("+OK", "Message deleted").immutable();
    private final MetricFactory metricFactory;
    private final POP3MessageCommandDelegate commandDelegate;

    @Inject
    public DeleCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.commandDelegate = new POP3MessageCommandDelegate(COMMANDS){

            @Override
            protected Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) {
                return DeleCmdHandler.this.scheduleMessageDeletion(session, data);
            }
        };
    }

    protected Response scheduleMessageDeletion(POP3Session session, MessageMetaData data) {
        List deletedUidList = session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElseGet(() -> {
            ArrayList uidList = new ArrayList();
            session.setAttachment(POP3Session.DELETED_UID_LIST, uidList, ProtocolSession.State.Transaction);
            return uidList;
        });
        deletedUidList.add(data.getUid());
        return DELETED;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-dele", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "DELE").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.commandDelegate.handleMessageRequest(session, request)));
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

