/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;

public class MailAddressCollectionReader {
    public static Set<Optional<MailAddress>> read(String condition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)condition) ? 1 : 0) != 0);
        return (Set)Splitter.onPattern((String)"(,| |\t)").splitToStream((CharSequence)condition).filter(Predicate.not(Strings::isNullOrEmpty)).map(MailAddressCollectionReader::getMailAddress).collect(ImmutableSet.toImmutableSet());
    }

    private static Optional<MailAddress> getMailAddress(String s) {
        try {
            if (s.equals("<>")) {
                return Optional.empty();
            }
            return Optional.of(new MailAddress(s));
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }
}

