/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageId;

public class BlobId {
    public static final String UPLOAD_PREFIX = "upload-";
    private final String rawValue;

    public static BlobId of(UploadId uploadId) {
        return BlobId.of(UPLOAD_PREFIX + uploadId.asString());
    }

    public static BlobId of(MessageId messageId) {
        return BlobId.of(messageId.serialize());
    }

    public static BlobId of(AttachmentId attachmentId) {
        return BlobId.of(attachmentId.getId());
    }

    public static BlobId of(String rawValue) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)rawValue) ? 1 : 0) != 0, (Object)"'rawValue' is mandatory");
        return new BlobId(rawValue);
    }

    private BlobId(String rawValue) {
        this.rawValue = rawValue;
    }

    @JsonValue
    public String getRawValue() {
        return this.rawValue;
    }

    public AttachmentId asAttachmentId() {
        return AttachmentId.from((String)this.rawValue);
    }

    public Optional<UploadId> asUploadId() {
        if (this.rawValue.startsWith(UPLOAD_PREFIX)) {
            UploadId uploadId = UploadId.from((String)this.rawValue.substring(UPLOAD_PREFIX.length()));
            return Optional.of(uploadId);
        }
        return Optional.empty();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BlobId) {
            BlobId other = (BlobId)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.rawValue);
    }

    public String toString() {
        return "BlobId{rawValue='" + this.rawValue + "'}";
    }
}

