/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import com.unboundid.util.args.IPAddressArgumentValueValidator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DNSHostNameArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = 1525611526290885612L;
    private final boolean allowIPAddresses;
    private final boolean allowUnqualifiedNames;
    private final boolean allowUnresolvableNames;
    @NotNull
    private final NameResolver nameResolver;

    public DNSHostNameArgumentValueValidator() {
        this(true, true, true, null);
    }

    public DNSHostNameArgumentValueValidator(boolean allowIPAddresses, boolean allowUnqualifiedNames, boolean allowUnresolvableNames, @Nullable NameResolver nameResolver) {
        this.allowIPAddresses = allowIPAddresses;
        this.allowUnqualifiedNames = allowUnqualifiedNames;
        this.allowUnresolvableNames = allowUnresolvableNames;
        this.nameResolver = nameResolver == null ? LDAPConnectionOptions.DEFAULT_NAME_RESOLVER : nameResolver;
    }

    public boolean allowIPAddresses() {
        return this.allowIPAddresses;
    }

    public boolean allowUnqualifiedNames() {
        return this.allowUnqualifiedNames;
    }

    public boolean allowUnresolvableNames() {
        return this.allowUnresolvableNames;
    }

    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    public void validateArgumentValue(@NotNull Argument argument, @NotNull String valueString) throws ArgumentException {
        try {
            DNSHostNameArgumentValueValidator.validateDNSHostName(valueString, this.allowIPAddresses, this.allowUnqualifiedNames, this.allowUnresolvableNames, this.nameResolver);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_INVALID_ARG_VALUE.get(String.valueOf(valueString), argument.getIdentifierString(), e.getMessage()), e);
        }
    }

    public static void validateDNSHostName(@NotNull String name) throws ArgumentException {
        DNSHostNameArgumentValueValidator.validateDNSHostName(name, true, true, true, null);
    }

    public static void validateDNSHostName(@Nullable String name, boolean allowIPAddresses, boolean allowUnqualifiedNames, boolean allowUnresolvableNames, @Nullable NameResolver nameResolver) throws ArgumentException {
        if (name == null || name.isEmpty()) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_NULL_OR_EMPTY.get());
        }
        if (name.contains("..")) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_CONSECUTIVE_PERIODS.get());
        }
        if (IPAddressArgumentValueValidator.isValidNumericIPAddress(name)) {
            if (allowIPAddresses) {
                return;
            }
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_IP_ADDRESS.get());
        }
        DNSHostNameArgumentValueValidator.validateDNSHostNameSyntax(name);
        if (!allowUnqualifiedNames && name.indexOf(46) < 0) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_NOT_QUALIFIED.get());
        }
        if (!allowUnresolvableNames) {
            try {
                NameResolver resolver = nameResolver == null ? LDAPConnectionOptions.DEFAULT_NAME_RESOLVER : nameResolver;
                resolver.getByName(name);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_NOT_RESOLVABLE.get(), e);
            }
        }
    }

    private static void validateDNSHostNameSyntax(@NotNull String name) throws ArgumentException {
        String nameWithoutTrailingPeriod;
        if (name.endsWith(".")) {
            nameWithoutTrailingPeriod = name.substring(0, name.length() - 1);
            if (nameWithoutTrailingPeriod.isEmpty()) {
                return;
            }
        } else {
            nameWithoutTrailingPeriod = name;
        }
        if (nameWithoutTrailingPeriod.length() > 255) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_NAME_TOO_LONG.get(nameWithoutTrailingPeriod.length()));
        }
        if (nameWithoutTrailingPeriod.startsWith(".")) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_STARTS_WITH_PERIOD.get());
        }
        int startPos = 0;
        int periodPos = nameWithoutTrailingPeriod.indexOf(46);
        while (periodPos > 0) {
            String component = nameWithoutTrailingPeriod.substring(startPos, periodPos);
            DNSHostNameArgumentValueValidator.validateDNSHostNameComponentSyntax(component);
            startPos = periodPos + 1;
            periodPos = nameWithoutTrailingPeriod.indexOf(46, startPos);
        }
        String lastComponent = nameWithoutTrailingPeriod.substring(startPos);
        DNSHostNameArgumentValueValidator.validateDNSHostNameComponentSyntax(lastComponent);
    }

    private static void validateDNSHostNameComponentSyntax(@NotNull String component) throws ArgumentException {
        if (component.length() > 63) {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_COMPONENT_TOO_LONG.get(component, component.length()));
        }
        if (component.charAt(0) == '-') {
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_COMPONENT_STARTS_WITH_HYPHEN.get(component));
        }
        for (int i = 0; i < component.length(); ++i) {
            char c = component.charAt(i);
            if (DNSHostNameArgumentValueValidator.isLetterDigitOrDash(c)) continue;
            if (c <= '\u007f') {
                throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_COMPONENT_ILLEGAL_ASCII_CHARACTER.get(component, i + 1));
            }
            throw new ArgumentException(ArgsMessages.ERR_DNS_NAME_VALIDATOR_COMPONENT_NON_ASCII_CHARACTER.get(component, i + 1));
        }
    }

    private static boolean isLetterDigitOrDash(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-';
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DNSHostNameArgumentValueValidator(allowIPAddresses=");
        buffer.append(this.allowIPAddresses);
        buffer.append(", allowUnqualifiedNames=");
        buffer.append(this.allowUnqualifiedNames);
        buffer.append(", allowUnresolvableNames=");
        buffer.append(this.allowUnresolvableNames);
        buffer.append(')');
    }
}

