/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.UploadSerializer;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.jmap.routes.TooBigUploadException;
import org.apache.james.jmap.routes.UploadResponse;
import org.apache.james.jmap.routes.UploadRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t%u!B\u0010!\u0011\u0003Yc!B\u0017!\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%\t\u0001\u000f\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001d\u0007\t5\u0002\u0003\u0001\u0011\u0005\t\u001b\u0016\u0011)\u0019!C\u0001\u001d\"AQ+\u0002B\u0001B\u0003%q\n\u0003\u0005W\u000b\t\u0015\r\u0011\"\u0001X\u0011!qVA!A!\u0002\u0013A\u0006\u0002C0\u0006\u0005\u000b\u0007I\u0011\u00011\t\u0011%,!\u0011!Q\u0001\n\u0005D\u0001B[\u0003\u0003\u0006\u0004%\ta\u001b\u0005\te\u0016\u0011\t\u0011)A\u0005Y\"A1/\u0002BC\u0002\u0013\u0005A\u000f\u0003\u0005y\u000b\t\u0005\t\u0015!\u0003v\u0011\u0015)T\u0001\"\u0001z\u0011%\t\t#\u0002b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u0002<\u0015\u0001\u000b\u0011BA\u0013\u0011%\ti$\u0002b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002F\u0015\u0001\u000b\u0011BA!\u0011\u0019\tS\u0001\"\u0011\u0002H!9\u0011qL\u0003\u0005\u0002\u0005\u0005\u0004bBA0\u000b\u0011\u0005\u00111\u0014\u0005\b\u0003\u001b,A\u0011BAh\u0011\u001d\ti-\u0002C\u0001\u0003KDqA!\u0001\u0006\t\u0003\u0011\u0019\u0001C\u0004\u0003\u0018\u0015!IA!\u0007\t\u000f\t-R\u0001\"\u0003\u0003.!9!QI\u0003\u0005\n\t\u001d\u0003\"\u0003B9\u000bE\u0005I\u0011\u0002B:\u00031)\u0006\u000f\\8bIJ{W\u000f^3t\u0015\t\t#%\u0001\u0004s_V$Xm\u001d\u0006\u0003G\u0011\nAA[7ba*\u0011QEJ\u0001\u0006U\u0006lWm\u001d\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051\nQ\"\u0001\u0011\u0003\u0019U\u0003Hn\\1e%>,H/Z:\u0014\u0005\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002W\u00051AjT$H\u000bJ+\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y!\nQa\u001d7gi)L!AP\u001e\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a2!B!J!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u00142kK\u000e$\bC\u0001&L\u001b\u0005\u0011\u0013B\u0001'#\u0005)QU*\u0011)S_V$Xm]\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES!A\u0015\u0012\u0002\t!$H\u000f]\u0005\u0003)F\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0012\u0002\t\r|'/Z\u0005\u0003;j\u0013\u0001DS7baJ37\r\u000f\u001c3c\r{gNZ5hkJ\fG/[8o\u00039\u0019wN\u001c4jOV\u0014\u0018\r^5p]\u0002\n\u0001#\u001e9m_\u0006$'+\u001a9pg&$xN]=\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\rU\u0004Hn\\1e\u0015\t1'%A\u0002ba&L!\u0001[2\u0003!U\u0003Hn\\1e%\u0016\u0004xn]5u_JL\u0018!E;qY>\fGMU3q_NLGo\u001c:zA\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0012\u0002\t)\u001cxN\\\u0005\u0003c:\u0014\u0001#\u00169m_\u0006$7+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014X#A;\u0011\u0005e3\u0018BA<[\u0005E\u0019Vm]:j_:$&/\u00198tY\u0006$xN]\u0001\u0013g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\b\u0005\u0006\u0006{w\u0006E\u00111CA\u000b\u0003/\u0001\"\u0001L\u0003\t\u000b5\u0003\u0002\u0019A()\rml\u00181BA\u0007!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0019IgN[3di*\u0011\u0011QA\u0001\u0006U\u00064\u0018\r_\u0005\u0004\u0003\u0013y(!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017EAA\b\u0003!\u0011fiQ\u00179mI\n\u0004\"\u0002,\u0011\u0001\u0004A\u0006\"B0\u0011\u0001\u0004\t\u0007\"\u00026\u0011\u0001\u0004a\u0007\"B:\u0011\u0001\u0004)\bf\u0001\t\u0002\u001cA\u0019a0!\b\n\u0007\u0005}qP\u0001\u0004J]*,7\r^\u0001\u000fC\u000e\u001cw.\u001e8u\u0013\u0012\u0004\u0016M]1n+\t\t)\u0003\u0005\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003c\u00012!a\u000b2\u001b\t\tiCC\u0002\u00020)\na\u0001\u0010:p_Rt\u0014bAA\u001ac\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\r2\u0003=\t7mY8v]RLE\rU1sC6\u0004\u0013!C;qY>\fG-\u0016*J+\t\t\t\u0005E\u0002C\u0003\u0007J1!a\u000eD\u0003))\b\u000f\\8bIV\u0013\u0016\n\t\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002V\u0005eSBAA'\u0015\u0011\ty%!\u0015\u0002\rM$(/Z1n\u0015\r\t\u0019&R\u0001\u0005kRLG.\u0003\u0003\u0002X\u00055#AB*ue\u0016\fW\u000eE\u0002K\u00037J1!!\u0018#\u0005%QU*\u0011)S_V$X-\u0001\u0003q_N$HCBA2\u0003w\n\t\n\u0005\u0004\u0002f\u0005E\u0014QO\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u00047\u00065$BAA8\u0003\u001d\u0011X-Y2u_JLA!a\u001d\u0002h\t!Qj\u001c8p!\r\u0011\u0015qO\u0005\u0004\u0003s\u001a%\u0001\u0002,pS\u0012Dq!! \u0017\u0001\u0004\ty(A\u0004sKF,Xm\u001d;\u0011\t\u0005\u0005\u0015QR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u000611/\u001a:wKJT1AUAE\u0015\u0011\tY)!\u001c\u0002\u000b9,G\u000f^=\n\t\u0005=\u00151\u0011\u0002\u0012\u0011R$\boU3sm\u0016\u0014(+Z9vKN$\bbBAJ-\u0001\u0007\u0011QS\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011\u0011QAL\u0013\u0011\tI*a!\u0003%!#H\u000f]*feZ,'OU3ta>t7/\u001a\u000b\u000b\u0003;\u000bI+a+\u0002.\u0006\u0005\u0007CBAP\u0003K\u000b)(\u0004\u0002\u0002\"*!\u0011\u0011NAR\u0015\r\u0011\u00141N\u0005\u0005\u0003O\u000b\tKA\u0003T\u001b>tw\u000eC\u0004\u0002~]\u0001\r!a \t\u000f\u0005Mu\u00031\u0001\u0002\u0016\"9\u0011qV\fA\u0002\u0005E\u0016aC2p]R,g\u000e\u001e+za\u0016\u0004B!a-\u0002>6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,A\u0003n_\u0012,GNC\u0002\u0002<\u0012\nq!\\1jY\n|\u00070\u0003\u0003\u0002@\u0006U&aC\"p]R,g\u000e\u001e+za\u0016Dq!a1\u0018\u0001\u0004\t)-\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u0017\u0011Z\u0007\u0003\u0003sKA!a3\u0002:\nqQ*Y5mE>D8+Z:tS>t\u0017A\u00025b]\u0012dW\r\u0006\u0007\u0002\u001e\u0006E\u00171[Ak\u0003/\fY\u000eC\u0004\u0002~a\u0001\r!a \t\u000f\u0005M\u0005\u00041\u0001\u0002\u0016\"9\u0011q\u0016\rA\u0002\u0005E\u0006bBAm1\u0001\u0007\u0011QY\u0001\bg\u0016\u001c8/[8o\u0011\u001d\ti\u000e\u0007a\u0001\u0003?\fq\u0002^1sO\u0016$\u0018iY2pk:$\u0018\n\u001a\t\u00043\u0006\u0005\u0018bAAr5\nI\u0011iY2pk:$\u0018\n\u001a\u000b\r\u0003;\u000b9/a;\u0002n\u0006u\u0018q \u0005\b\u0003SL\u0002\u0019AAp\u0003%\t7mY8v]RLE\rC\u0004\u00020f\u0001\r!!-\t\u000f\u0005=\u0018\u00041\u0001\u0002r\u000691m\u001c8uK:$\b\u0003BAz\u0003sl!!!>\u000b\u0007\u0005]X)\u0001\u0002j_&!\u00111`A{\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005\r\u0017\u00041\u0001\u0002F\"9\u00111S\rA\u0002\u0005U\u0015!D;qY>\fGmQ8oi\u0016tG\u000f\u0006\u0006\u0003\u0006\t5!q\u0002B\t\u0005+\u0001b!a(\u0002&\n\u001d\u0001c\u0001\u0017\u0003\n%\u0019!1\u0002\u0011\u0003\u001dU\u0003Hn\\1e%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u001e\u000eA\u0002\u0005}\u0007bBAX5\u0001\u0007\u0011\u0011\u0017\u0005\b\u0005'Q\u0002\u0019AAy\u0003-Ig\u000e];u'R\u0014X-Y7\t\u000f\u0005e'\u00041\u0001\u0002F\u0006qaM]8n\u0003R$\u0018m\u00195nK:$HC\u0002B\u0004\u00057\u0011I\u0003C\u0004\u0003\u001em\u0001\rAa\b\u0002\u001dU\u0004Hn\\1e\u001b\u0016$\u0018\rR1uCB!!\u0011\u0005B\u0013\u001b\t\u0011\u0019CC\u0002\u00028\u0016LAAa\n\u0003$\tqQ\u000b\u001d7pC\u0012lU\r^1ECR\f\u0007bBAu7\u0001\u0007\u0011q\\\u0001\tCN\u0014En\u001c2JIR!!q\u0006B\u001e!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"b\u0001B\u001bE\u0005!Q.Y5m\u0013\u0011\u0011IDa\r\u0003\r\tcwNY%e\u0011\u001d\u0011i\u0004\ba\u0001\u0005\u007f\t\u0001\"\u001e9m_\u0006$\u0017\n\u001a\t\u0005\u0005C\u0011\t%\u0003\u0003\u0003D\t\r\"\u0001C+qY>\fG-\u00133\u0002\u001dI,7\u000f]8oI\u0012+G/Y5mgRA\u0011Q\u0014B%\u0005\u001b\u00129\u0006C\u0004\u0003Lu\u0001\r!!&\u0002%!$H\u000f]*feZ,'OU3ta>t7/\u001a\u0005\b\u0005\u001fj\u0002\u0019\u0001B)\u0003\u001d!W\r^1jYN\u00042!\u0017B*\u0013\r\u0011)F\u0017\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0011%\u0011I&\bI\u0001\u0002\u0004\u0011Y&\u0001\u0006ti\u0006$Xo]\"pI\u0016\u0004BA!\u0018\u0003n5\u0011!q\f\u0006\u0004%\n\u0005$\u0002\u0002B2\u0005K\nQaY8eK\u000eTAAa\u001a\u0003j\u00059\u0001.\u00198eY\u0016\u0014(\u0002BAF\u0005WR!!a>\n\t\t=$q\f\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8/\u0001\rsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:%I\u00164\u0017-\u001e7uIM*\"A!\u001e+\t\tm#qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u0019!1Q\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\nu$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class UploadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final JmapRfc8621Configuration configuration;
    private final UploadRepository uploadRepository;
    private final UploadSerializer serializer;
    private final SessionTranslator sessionTranslator;
    private final String accountIdParam;
    private final String uploadURI;

    public static Logger LOGGER() {
        return UploadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public UploadRepository uploadRepository() {
        return this.uploadRepository;
    }

    public UploadSerializer serializer() {
        return this.serializer;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String uploadURI() {
        return this.uploadURI;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, this.uploadURI())).action((request, response) -> this.post(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.uploadURI())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    public Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        String string2 = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)session -> this.post(request, response, ContentType.of((String)string2), (MailboxSession)session)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                UploadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
                String x$2 = unauthorizedException.getMessage();
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
            }
            if (throwable instanceof TooBigUploadException) {
                HttpResponseStatus x$5 = HttpResponseStatus.BAD_REQUEST;
                String x$6 = "Attempt to upload exceed max size";
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, "Attempt to upload exceed max size"), HttpResponseStatus.BAD_REQUEST);
            }
            if (throwable instanceof ForbiddenException ? true : throwable instanceof AccountNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.FORBIDDEN;
                String x$10 = "Upload to other accounts is forbidden";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "Upload to other accounts is forbidden"), HttpResponseStatus.FORBIDDEN);
            }
            UploadRoutes$.MODULE$.LOGGER().error("Unexpected error upon uploads", throwable);
            HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$14 = throwable.getMessage();
            String x$15 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }).asJava().subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }

    public SMono<Void> post(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            return this.sessionTranslator().delegateIfNeeded(mailboxSession, targetAccountId).flatMap((Function1 & Serializable)session -> this.handle(request, response, contentType, (MailboxSession)session, targetAccountId));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<Void> handle(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession session, AccountId targetAccountId) {
        return SMono$.MODULE$.fromCallable(() -> ReactorUtils.toInputStream((Flux)request.receive().asByteArray().map(array -> ByteBuffer.wrap(array)))).flatMap((Function1 & Serializable)content -> this.handle(targetAccountId, contentType, (InputStream)content, session, response));
    }

    public SMono<Void> handle(AccountId accountId, ContentType contentType, InputStream content, MailboxSession mailboxSession, HttpServerResponse response) {
        long maxSize = BoxesRunTime.unboxToLong((Object)this.configuration().maxUploadSize().value());
        return SMono$.MODULE$.fromCallable(() -> new LimitedInputStream(null, content, maxSize){

            public void raiseError(long max, long count) {
                if (count > max) {
                    throw new TooBigUploadException();
                }
            }
        }).flatMap((Function1 & Serializable)x$1 -> this.uploadContent(accountId, contentType, (InputStream)x$1, mailboxSession)).flatMap((Function1 & Serializable)uploadResponse -> {
            JsValue jsonValue = this.serializer().serialize((UploadResponse)uploadResponse);
            String json = Json$.MODULE$.stringify(jsonValue);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            return SMono$.MODULE$.fromPublisher((Publisher)response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(bytes.length)).status(HttpResponseStatus.CREATED).sendByteArray((Publisher)SMono$.MODULE$.just((Object)bytes)));
        });
    }

    public SMono<UploadResponse> uploadContent(AccountId accountId, ContentType contentType, InputStream inputStream, MailboxSession session) {
        return SMono$.MODULE$.fromPublisher(this.uploadRepository().upload(inputStream, contentType, session.getUser())).map((Function1 & Serializable)x$2 -> this.fromAttachment((UploadMetaData)x$2, accountId));
    }

    private UploadResponse fromAttachment(UploadMetaData uploadMetaData, AccountId accountId) {
        BlobId x$1 = this.asBlobId(uploadMetaData.uploadId());
        ContentType x$2 = uploadMetaData.contentType();
        Long x$3 = uploadMetaData.size();
        AccountId x$4 = accountId;
        return new UploadResponse(x$4, x$1, x$2, x$3);
    }

    private BlobId asBlobId(UploadId uploadId) {
        return (BlobId)BlobId$.MODULE$.of(new StringBuilder(8).append("uploads-").append(uploadId.asString()).toString()).get();
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    @Inject
    public UploadRoutes(@Named(value="RFC-8621") Authenticator authenticator, JmapRfc8621Configuration configuration, UploadRepository uploadRepository, UploadSerializer serializer, SessionTranslator sessionTranslator) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.uploadRepository = uploadRepository;
        this.serializer = serializer;
        this.sessionTranslator = sessionTranslator;
        this.accountIdParam = "accountId";
        this.uploadURI = new StringBuilder(10).append("/upload/{").append(this.accountIdParam()).append("}").toString();
    }
}

