/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.util.Arrays;
import javax.management.ObjectName;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.slf4j.Logger;

public class AuditLogger_impl
implements AuditLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public AuditLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void getRoutingTypes(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601000: User {} is getting routing type property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRoutingTypesAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601001: User {} is getting routing type property as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getQueueNames(String user, Object source, String parameters) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601002: User {} is getting queue names on target resource: {} {}", new Object[]{user, source, parameters});
        }
    }

    @Override
    public void getBindingNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601003: User {} is getting binding names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRoles(String user, Object source, String parameters) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601004: User {} is getting roles on target resource: {} {}", new Object[]{user, source, parameters});
        }
    }

    @Override
    public void getRolesAsJSON(String user, Object source, String parameters) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601005: User {} is getting roles as json on target resource: {} {}", new Object[]{user, source, parameters});
        }
    }

    @Override
    public void getNumberOfBytesPerPage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601006: User {} is getting number of bytes per page on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAddressSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601007: User {} is getting address size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getNumberOfMessages(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601008: User {} is getting number of messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPaging(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601009: User {} is getting isPaging on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getNumberOfPages(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601010: User {} is getting number of pages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRoutedMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601011: User {} is getting routed message count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getUnRoutedMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601012: User {} is getting unrouted message count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void sendMessageThroughManagement(String user, Object source, String parameters) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601013: User {} is sending a message on target resource: {} {}", new Object[]{user, source, parameters});
        }
    }

    @Override
    public void getName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601014: User {} is getting name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601015: User {} is getting address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFilter(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601016: User {} is getting filter on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isDurable(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601017: User {} is getting durable property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601018: User {} is getting message count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMBeanInfo(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601019: User {} is getting mbean info on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFactoryClassName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601020: User {} is getting factory class name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getParameters(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601021: User {} is getting parameters on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void reload(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601022: User {} is doing reload on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isStarted(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601023: User {} is querying isStarted on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void startAcceptor(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601024: User {} is starting an acceptor on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void stopAcceptor(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601025: User {} is stopping an acceptor on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getVersion(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601026: User {} is getting version on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isBackup(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601027: User {} is querying isBackup on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isSharedStore(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601028: User {} is querying isSharedStore on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getBindingsDirectory(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601029: User {} is getting bindings directory on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getIncomingInterceptorClassNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601030: User {} is getting incoming interceptor class names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getOutgoingInterceptorClassNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601031: User {} is getting outgoing interceptor class names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalBufferSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601032: User {} is getting journal buffer size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalBufferTimeout(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601033: User {} is getting journal buffer timeout on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void setFailoverOnServerShutdown(String user, Object source, String parameters) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601034: User {} is setting failover on server shutdown on target resource: {} {}", new Object[]{user, source, parameters});
        }
    }

    @Override
    public void isFailoverOnServerShutdown(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601035: User {} is querying is-failover-on-server-shutdown on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalMaxIO(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601036: User {} is getting journal's max io on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalDirectory(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601037: User {} is getting journal directory on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalFileSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601038: User {} is getting journal file size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalMinFiles(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601039: User {} is getting journal min files on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalCompactMinFiles(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601040: User {} is getting journal compact min files on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalCompactPercentage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601041: User {} is getting journal compact percentage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPersistenceEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601042: User {} is querying persistence enabled on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getJournalType(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601043: User {} is getting journal type on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getPagingDirectory(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601044: User {} is getting paging directory on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getScheduledThreadPoolMaxSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601045: User {} is getting scheduled threadpool max size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getThreadPoolMaxSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601046: User {} is getting threadpool max size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getSecurityInvalidationInterval(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601047: User {} is getting security invalidation interval on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isClustered(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601048: User {} is querying is-clustered on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isCreateBindingsDir(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601049: User {} is querying is-create-bindings-dir on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isCreateJournalDir(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601050: User {} is querying is-create-journal-dir on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isJournalSyncNonTransactional(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601051: User {} is querying is-journal-sync-non-transactional on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isJournalSyncTransactional(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601052: User {} is querying is-journal-sync-transactional on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isSecurityEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601053: User {} is querying is-security-enabled on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isAsyncConnectionExecutionEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601054: User {} is query is-async-connection-execution-enabled on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDiskScanPeriod(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601055: User {} is getting disk scan period on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMaxDiskUsage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601056: User {} is getting max disk usage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getGlobalMaxSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601057: User {} is getting global max size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAddressMemoryUsage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601058: User {} is getting address memory usage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAddressMemoryUsagePercentage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601059: User {} is getting address memory usage percentage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void freezeReplication(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601060: User {} is freezing replication on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void createAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601061: User {} is creating an address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void updateAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601062: User {} is updating an address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void deleteAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601063: User {} is deleting an address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void deployQueue(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601064: User {} is creating a queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void createQueue(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601065: User {} is creating a queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void updateQueue(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601066: User {} is updating a queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getClusterConnectionNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601067: User {} is getting cluster connection names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getUptime(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601068: User {} is getting uptime on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getUptimeMillis(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601069: User {} is getting uptime in milliseconds on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isReplicaSync(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601070: User {} is querying is-replica-sync on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAddressNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601071: User {} is getting address names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void destroyQueue(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601072: User {} is deleting a queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getAddressInfo(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601073: User {} is getting address info on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listBindingsForAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601074: User {} is listing bindings for address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listAddresses(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601075: User {} is listing addresses on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getConnectionCount(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601076: User {} is getting connection count on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getTotalConnectionCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601077: User {} is getting total connection count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTotalMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601078: User {} is getting total message count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTotalMessagesAdded(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601079: User {} is getting total messages added on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTotalMessagesAcknowledged(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601080: User {} is getting total messages acknowledged on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTotalConsumerCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601081: User {} is getting total consumer count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void enableMessageCounters(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601082: User {} is enabling message counters on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void disableMessageCounters(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601083: User {} is disabling message counters on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetAllMessageCounters(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601084: User {} is resetting all message counters on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetAllMessageCounterHistories(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601085: User {} is resetting all message counter histories on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isMessageCounterEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601086: User {} is querying is-message-counter-enabled on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessageCounterSamplePeriod(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601087: User {} is getting message counter sample period on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void setMessageCounterSamplePeriod(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601088: User {} is setting message counter sample period on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getMessageCounterMaxDayCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601089: User {} is getting message counter max day count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void setMessageCounterMaxDayCount(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601090: User {} is setting message counter max day count on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listPreparedTransactions(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601091: User {} is listing prepared transactions on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listPreparedTransactionDetailsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601092: User {} is listing prepared transaction details as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listPreparedTransactionDetailsAsHTML(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601093: User {} is listing prepared transaction details as HTML on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listHeuristicCommittedTransactions(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601094: User {} is listing heuristic committed transactions on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listHeuristicRolledBackTransactions(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601095: User {} is listing heuristic rolled back transactions on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void commitPreparedTransaction(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601096: User {} is commiting prepared transaction on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void rollbackPreparedTransaction(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601097: User {} is rolling back prepared transaction on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listRemoteAddresses(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601098: User {} is listing remote addresses on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeConnectionsForAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601099: User {} is closing connections for address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeConsumerConnectionsForAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601100: User {} is closing consumer connections for address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeConnectionsForUser(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601101: User {} is closing connections for user on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeConnectionWithID(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601102: User {} is closing a connection by ID on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeSessionWithID(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601103: User {} is closing session with id on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void closeConsumerWithID(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601104: User {} is closing consumer with id on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listConnectionIDs(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601105: User {} is listing connection IDs on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listSessions(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601106: User {} is listing sessions on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listProducersInfoAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601107: User {} is listing producers info as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listConnections(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601108: User {} is listing connections on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listConsumers(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601109: User {} is listing consumers on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listQueues(String user, Object source, String arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601110: User {} is listing queues on target resource: {} {}", new Object[]{user, source, arg});
        }
    }

    @Override
    public void listProducers(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601111: User {} is listing producers on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listConnectionsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601112: User {} is listing connections as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listSessionsAsJSON(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601113: User {} is listing sessions as json on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listAllSessionsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601114: User {} is listing all sessions as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listConsumersAsJSON(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601115: User {} is listing consumers as json on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listAllConsumersAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601116: User {} is listing all consumers as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConnectors(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601117: User {} is getting connectors on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConnectorsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601118: User {} is getting connectors as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void addSecuritySettings(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601119: User {} is adding security settings on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeSecuritySettings(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601120: User {} is removing security settings on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getAddressSettingsAsJSON(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601121: User {} is getting address settings as json on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void addAddressSettings(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601122: User {} is adding addressSettings on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeAddressSettings(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601123: User {} is removing address settings on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getDivertNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601124: User {} is getting divert names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void createDivert(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601125: User {} is creating a divert on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void destroyDivert(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601126: User {} is destroying a divert on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getBridgeNames(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601127: User {} is getting bridge names on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void createBridge(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601128: User {} is creating a bridge on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void destroyBridge(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601129: User {} is destroying a bridge on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void createConnectorService(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601130: User {} is creating connector service on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void destroyConnectorService(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601131: User {} is destroying connector service on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getConnectorServices(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601132: User {} is getting connector services on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void forceFailover(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601133: User {} is forceing a failover on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void scaleDown(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601134: User {} is performing scale down on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listNetworkTopology(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601135: User {} is listing network topology on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void removeNotificationListener(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601136: User {} is removing notification listener on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void addNotificationListener(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601137: User {} is adding notification listener on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getNotificationInfo(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601138: User {} is getting notification info on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConnectionTTLOverride(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601139: User {} is getting connection ttl override on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getIDCacheSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601140: User {} is getting ID cache size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getLargeMessagesDirectory(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601141: User {} is getting large message directory on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getManagementAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601142: User {} is getting management address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getNodeID(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601143: User {} is getting node ID on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getManagementNotificationAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601144: User {} is getting management notification address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessageExpiryScanPeriod(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601145: User {} is getting message expiry scan period on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessageExpiryThreadPriority(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601146: User {} is getting message expiry thread priority on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTransactionTimeout(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601147: User {} is getting transaction timeout on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTransactionTimeoutScanPeriod(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601148: User {} is getting transaction timeout scan period on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPersistDeliveryCountBeforeDelivery(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601149: User {} is querying is-persist-delivery-before-delivery on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPersistIDCache(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601150: User {} is querying is-persist-id-cache on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isWildcardRoutingEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601151: User {} is querying is-wildcard-routing-enabled on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void addUser(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601152: User {} is adding a user on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listUser(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601153: User {} is listing a user on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeUser(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601154: User {} is removing a user on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void resetUser(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601155: User {} is resetting a user on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getUser(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601156: User {} is getting user property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRoutingType(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601157: User {} is getting routing type property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isTemporary(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601158: User {} is getting temporary property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getPersistentSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601159: User {} is getting persistent size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurableMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601160: User {} is getting durable message count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurablePersistSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601161: User {} is getting durable persist size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConsumerCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601162: User {} is getting consumer count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDeliveringCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601163: User {} is getting delivering count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDeliveringSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601164: User {} is getting delivering size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurableDeliveringCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601165: User {} is getting durable delivering count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurableDeliveringSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601166: User {} is getting durable delivering size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessagesAdded(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601167: User {} is getting messages added on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessagesAcknowledged(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601168: User {} is getting messages acknowledged on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessagesExpired(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601169: User {} is getting messages expired on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessagesKilled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601170: User {} is getting messages killed on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getID(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601171: User {} is getting ID on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getScheduledCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601172: User {} is getting scheduled count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getScheduledSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601173: User {} is getting scheduled size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurableScheduledCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601174: User {} is getting durable scheduled count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDurableScheduledSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601175: User {} is getting durable scheduled size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDeadLetterAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601176: User {} is getting dead letter address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getExpiryAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601177: User {} is getting expiry address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMaxConsumers(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601178: User {} is getting max consumers on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPurgeOnNoConsumers(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601179: User {} is getting purge-on-consumers property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isConfigurationManaged(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601180: User {} is getting configuration-managed property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isExclusive(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601181: User {} is getting exclusive property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isLastValue(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601182: User {} is getting last-value property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listScheduledMessages(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601183: User {} is listing scheduled messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listScheduledMessagesAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601184: User {} is listing scheduled messages as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listDeliveringMessages(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601185: User {} is listing delivering messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listDeliveringMessagesAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601186: User {} is listing delivering messages as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601187: User {} is listing messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listMessagesAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601188: User {} is listing messages as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFirstMessage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601189: User {} is getting first message on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFirstMessageAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601190: User {} is getting first message as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFirstMessageTimestamp(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601191: User {} is getting first message's timestamp on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFirstMessageAge(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601192: User {} is getting first message's age on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void countMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601193: User {} is counting messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void countDeliveringMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601194: User {} is counting delivery messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeMessage(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601195: User {} is removing a message on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601196: User {} is removing messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void expireMessage(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601197: User {} is expiring messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void expireMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601198: User {} is expiring messages on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void retryMessage(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601199: User {} is retry sending message on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void retryMessages(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601200: User {} is retry sending messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void moveMessage(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601201: User {} is moving a message to another queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void moveMessages(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601202: User {} is moving messages to another queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void sendMessagesToDeadLetterAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601203: User {} is sending messages to dead letter address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void sendMessageToDeadLetterAddress(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601204: User {} is sending messages to dead letter address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void changeMessagesPriority(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601205: User {} is changing message's priority on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void changeMessagePriority(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601206: User {} is changing a message's priority on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listMessageCounter(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601207: User {} is listing message counter on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetMessageCounter(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601208: User {} is resetting message counter on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listMessageCounterAsHTML(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601209: User {} is listing message counter as HTML on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listMessageCounterHistory(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601210: User {} is listing message counter history on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listMessageCounterHistoryAsHTML(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601211: User {} is listing message counter history as HTML on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void pause(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601212: User {} is pausing on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void resume(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601213: User {} is resuming on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isPaused(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601214: User {} is getting paused property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void browse(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601215: User {} is browsing a queue on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void flushExecutor(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601216: User {} is flushing executor on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetAllGroups(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601217: User {} is resetting all groups on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetGroup(String user, Object source, String arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601218: User {} is resetting group on target resource: {} {}", new Object[]{user, source, arg});
        }
    }

    @Override
    public void getGroupCount(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601219: User {} is getting group count on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void listGroupsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601220: User {} is listing groups as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetMessagesAdded(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601221: User {} is resetting added messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetMessagesAcknowledged(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601222: User {} is resetting acknowledged messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetMessagesExpired(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601223: User {} is resetting expired messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void resetMessagesKilled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601224: User {} is resetting killed messages on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getStaticConnectors(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601225: User {} is getting static connectors on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getForwardingAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601226: User {} is getting forwarding address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getQueueName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601227: User {} is getting the queue name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDiscoveryGroupName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601228: User {} is getting discovery group name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFilterString(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601229: User {} is getting filter string on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getReconnectAttempts(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601230: User {} is getting reconnect attempts on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRetryInterval(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601231: User {} is getting retry interval on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getRetryIntervalMultiplier(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601232: User {} is getting retry interval multiplier on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTransformerClassName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601233: User {} is getting transformer class name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTransformerPropertiesAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601234: User {} is getting transformer properties as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTransformerProperties(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601235: User {} is getting transformer properties on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isStartedBridge(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601236: User {} is checking if bridge started on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isUseDuplicateDetection(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601237: User {} is querying use duplicate detection on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isHA(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601238: User {} is querying isHA on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void startBridge(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601239: User {} is starting a bridge on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void stopBridge(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601240: User {} is stopping a bridge on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessagesPendingAcknowledgement(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601241: User {} is getting messages pending acknowledgement on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMetrics(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601242: User {} is getting metrics on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getBroadcastPeriod(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601243: User {} is getting broadcast period on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConnectorPairs(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601244: User {} is getting connector pairs on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getConnectorPairsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601245: User {} is getting connector pairs as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getGroupAddress(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601246: User {} is getting group address on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getGroupPort(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601247: User {} is getting group port on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getLocalBindPort(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601248: User {} is getting local binding port on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void startBroadcastGroup(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601249: User {} is starting broadcasting group on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void stopBroadcastGroup(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601250: User {} is stopping broadcasting group on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMaxHops(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601251: User {} is getting max hops on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getStaticConnectorsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601252: User {} is geting static connectors as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isDuplicateDetection(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601253: User {} is querying use duplicate detection on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMessageLoadBalancingType(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601254: User {} is getting message loadbalancing type on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getTopology(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601255: User {} is getting topology on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getNodes(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601256: User {} is getting nodes on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void startClusterConnection(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601257: User {} is start cluster connection on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void stopClusterConnection(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601258: User {} is stop cluster connection on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getBridgeMetrics(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601259: User {} is getting bridge metrics on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getRoutingName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601260: User {} is getting routing name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getUniqueName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601261: User {} is getting unique name on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void serverSessionCreateAddress2(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601262: User {} is creating address on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void handleManagementMessage2(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601263: User {} is handling a management message on target resource {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void securityFailure(String user, String reason, Throwable cause) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601264: User {} gets security check failure, reason = {}", new Object[]{user, reason, cause});
        }
    }

    @Override
    public void createCoreConsumer(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601265: User {} is creating a core consumer on target resource {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void createSharedQueue(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601266: User {} is creating a shared queue on target resource {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void createCoreSession(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601267: User {} is creating a core session on target resource {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getAcknowledgeAttempts(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601269: User {} is getting messages acknowledged attempts on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getRingSize(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601270: User {} is getting ring size on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void isRetroactiveResource(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601271: User {} is getting retroactiveResource property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDiskStoreUsage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601272: User {} is getting disk store usage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getDiskStoreUsagePercentage(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601273: User {} is getting disk store usage percentage on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isGroupRebalance(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601274: User {} is getting group rebalance property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getGroupBuckets(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601275: User {} is getting group buckets on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getGroupFirstKey(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601276: User {} is getting group first key on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getCurrentDuplicateIdCacheSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601509: User {} is getting currentDuplicateIdCacheSize property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void clearDuplicateIdCache(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601510: User {} is clearing duplicate ID cache on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getChannelName(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601511: User {} is getting channelName property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFileContents(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601512: User {} is getting fileContents property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getFile(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601513: User {} is getting file property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getPreparedTransactionMessageCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601514: User {} is getting preparedTransactionMessageCount property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void coreSendMessage(String user, String messageToString, Object context, String tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601500: User {} sent a message {}, context: {}, transaction: {}", new Object[]{user, messageToString, context, tx});
        }
    }

    @Override
    public void consumeMessage(String user, String address, String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601501: User {} is consuming a message from {}: {}", new Object[]{user, address, message});
        }
    }

    @Override
    public void coreAcknowledgeMessage(String user, String queue, String message, String tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601502: User {} acknowledged message from {}: {}, transaction: {}", new Object[]{user, queue, message, tx});
        }
    }

    @Override
    public void createAddressSuccess(String user, String name, String routingTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601701: User {} successfully created address: {} with routing types {}", new Object[]{user, name, routingTypes});
        }
    }

    @Override
    public void createAddressFailure(String user, String name, String routingTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601702: User {} failed to created address: {} with routing types {}", new Object[]{user, name, routingTypes});
        }
    }

    @Override
    public void updateAddressSuccess(String user, String name, String routingTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601703: User {} successfully updated address: {} with routing types {}", new Object[]{user, name, routingTypes});
        }
    }

    @Override
    public void updateAddressFailure(String user, String name, String routingTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601704: User {} successfully updated address: {} with routing types {}", new Object[]{user, name, routingTypes});
        }
    }

    @Override
    public void deleteAddressSuccess(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601705: User {} successfully deleted address: {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void deleteAddressFailure(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601706: User {} failed to deleted address: {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void createQueueSuccess(String user, String name, String address, String routingType) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601707: User {} successfully created queue: {} on address: {} with routing type {}", new Object[]{user, name, address, routingType});
        }
    }

    @Override
    public void createQueueFailure(String user, String name, String address, String routingType) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601708: User {} failed to create queue: {} on address: {} with routing type {}", new Object[]{user, name, address, routingType});
        }
    }

    @Override
    public void updateQueueSuccess(String user, String name, String routingType) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601709: User {} successfully updated queue: {} with routing type {}", new Object[]{user, name, routingType});
        }
    }

    @Override
    public void updateQueueFailure(String user, String name, String routingType) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601710: User {} failed to update queue: {} with routing type {}", new Object[]{user, name, routingType});
        }
    }

    @Override
    public void destroyQueueSuccess(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601711: User {} successfully deleted queue: {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void destroyQueueFailure(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601712: User {} failed to delete queue: {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void removeMessagesSuccess(String user, int removed, String queue) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601713: User {} has removed {} messages from queue: {}", new Object[]{user, removed, queue});
        }
    }

    @Override
    public void removeMessagesFailure(String user, String queue) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601714: User {} failed to remove messages from queue: {}", (Object)user, (Object)queue);
        }
    }

    @Override
    public void userSuccesfullyAuthenticated(String caller) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601715: User {} successfully authenticated", (Object)caller);
        }
    }

    @Override
    public void userFailedAuthentication(String user, String reason) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601716: User {} failed authentication, reason: {}", (Object)user, (Object)reason);
        }
    }

    @Override
    public void objectInvokedSuccessfully(String caller, ObjectName objectName, String operationName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601717: User {} accessed {} on management object {}", new Object[]{caller, objectName, operationName});
        }
    }

    @Override
    public void objectInvokedFailure(String caller, ObjectName objectName, String operationName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601718: User {} does not have correct role to access {} on management object {}", new Object[]{caller, objectName, operationName});
        }
    }

    @Override
    public void pauseQueueSuccess(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601719: User {} has paused queue {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void pauseQueueFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601720: User {} failed to pause queue {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void resumeQueueSuccess(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601721: User {} has resumed queue {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void resumeQueueFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601722: User {} failed to resume queue {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void sendMessageSuccess(String user, String queueName, String sendUser) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601723: User {} sent message to {} as user {}", new Object[]{user, queueName, sendUser});
        }
    }

    @Override
    public void sendMessageFailure(String user, String queueName, String sendUser) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601724: User {} failed to send message to {} as user {}", new Object[]{user, queueName, sendUser});
        }
    }

    @Override
    public void browseMessagesSuccess(String user, int numMessages, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601725: User {} browsed {} messages from queue {}", new Object[]{user, numMessages, queueName});
        }
    }

    @Override
    public void browseMessagesFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601726: User {} failed to browse messages from queue {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void updateDivert(String user, Object source, String arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601727: User {} is updating a divert on target resource: {} {}", new Object[]{user, source, arg});
        }
    }

    @Override
    public void isEnabled(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601728: User {} is getting enabled property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void disable(String user, Object source, String arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601729: User {} is disabling on target resource: {} {}", new Object[]{user, source, arg});
        }
    }

    @Override
    public void enable(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601730: User {} is enabling on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void pauseAddressSuccess(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601731: User {} has paused address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void pauseAddressFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601732: User {} failed to pause address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void resumeAddressSuccess(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601733: User {} has resumed address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void resumeAddressFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601734: User {} failed to resume address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void isGroupRebalancePauseDispatch(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601735: User {} is getting group rebalance pause dispatch property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAuthenticationCacheSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601736: User {} is getting authentication cache size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAuthorizationCacheSize(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601737: User {} is getting authorization cache size on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void listBrokerConnections(String user) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601738: User {} is requesting a list of broker connections", (Object)user);
        }
    }

    @Override
    public void stopBrokerConnection(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601739: User {} is requesting to stop broker connection {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void startBrokerConnection(String user, String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601740: User {} is requesting to start broker connection {}", (Object)user, (Object)name);
        }
    }

    @Override
    public void getAddressCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601741: User {} is getting address count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getQueueCount(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601742: User {} is getting the queue count on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void lastValueKey(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601743: User {} is getting last-value-key property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void consumersBeforeDispatch(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601744: User {} is getting consumers-before-dispatch property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void delayBeforeDispatch(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601745: User {} is getting delay-before-dispatch property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isInternal(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601746: User {} is getting internal property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isAutoCreated(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601747: User {} is getting auto-created property on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getMaxRetryInterval(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601748: User {} is getting max retry interval on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getActivationSequence(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601749: User {} is getting activation sequence on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void purge(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601750: User {} is purging target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void purgeAddressSuccess(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601751: User {} has purged address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void purgeAddressFailure(String user, String queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601752: User {} failed to purge address {}", (Object)user, (Object)queueName);
        }
    }

    @Override
    public void getAddressLimitPercent(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601753: User {} is getting address limit %  on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void block(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601754: User {} is blocking target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void unBlock(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601755: User {} is unblocking target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAcceptors(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601756: User {} is getting acceptors on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void getAcceptorsAsJSON(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601757: User {} is getting acceptors as json on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void schedulePageCleanup(String user, Object address) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601758: User {} is calling schedulePageCleanup on address: {}", (Object)user, address);
        }
    }

    @Override
    public void addAckToTransaction(String user, String queue, String message, String tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601759: User {} added acknowledgement of a message from {}: {} to transaction: {}", new Object[]{user, queue, message, tx});
        }
    }

    @Override
    public void addSendToTransaction(String user, String messageToString, String tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601760: User {} added a message send for: {} to transaction: {}", new Object[]{user, messageToString, tx});
        }
    }

    @Override
    public void rolledBackTransaction(String user, String tx, String resource) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601761: User {} rolled back transaction {} involving {}", new Object[]{user, tx, resource});
        }
    }

    @Override
    public void addConnector(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601762: User {} is adding a connector on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void removeConnector(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601763: User {} is removing a connector on target resource: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void deliverScheduledMessage(String user, Object source, String args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601764: User {} is calling deliverScheduledMessage on queue: {} {}", new Object[]{user, source, args});
        }
    }

    @Override
    public void getStatus(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601765: User {} is getting status on target resource: {}", (Object)user, source);
        }
    }

    @Override
    public void isAutoDelete(String user, Object source) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ601766: User {} is getting auto-delete property on target resource: {}", (Object)user, source);
        }
    }
}

